/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.StreamCopy;
import java.io.File;
import java.io.IOException;

public class FileUtils {
    public static void copy(File src, File dst) throws IOException {
        StreamCopy.copy(src, dst, false);
    }

    public static synchronized File createTempDir(String prefix, File directory) throws IOException {
        int rand;
        String tmpDirName;
        if (directory == null) {
            directory = new File(System.getProperty("java.io.tmpdir"));
        }
        File tmpDir = null;
        do {
            rand = (int)(Math.random() * 1000000.0);
        } while ((tmpDir = new File(directory, tmpDirName = String.valueOf(prefix) + Integer.toString(rand))).exists());
        boolean created = tmpDir.mkdir();
        if (!created) {
            throw new IOException("Could not create temporary directory!");
        }
        return tmpDir;
    }

    public static boolean deleteRecursive(File dir) {
        File[] fileList = dir.listFiles();
        if (fileList != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f != null) {
                    if (f.isDirectory()) {
                        FileUtils.deleteRecursive(f);
                    } else {
                        f.delete();
                    }
                }
                ++n2;
            }
        }
        return dir.delete();
    }

    public static File moveToBackup(File file, String backupSuffix) {
        File retFile = null;
        if (file != null && file.exists()) {
            File backupFile = new File(String.valueOf(file.getPath()) + backupSuffix);
            boolean bkfDeleted = true;
            if (backupFile.exists()) {
                bkfDeleted = backupFile.delete();
            }
            if (bkfDeleted) {
                boolean moved = file.renameTo(backupFile);
                if (!moved) {
                    new IOException("Backup file error! Could not move " + file + " as backup to " + backupFile + " !");
                } else {
                    retFile = backupFile;
                }
            } else {
                new IOException("Backup file error! Could not delete old backup file:\n" + backupFile + " !");
            }
        }
        return retFile;
    }
}

