/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math;

import ipsk.math.Complex;
import ipsk.math.HammingWindow;
import ipsk.math.Window;

public class DFTProcessor {
    private int size;
    private int channels;
    private Window w;

    public DFTProcessor(int size, int channels, Window window) {
        this.size = size;
        this.channels = channels;
        this.w = window;
    }

    public DFTProcessor(int size, int channels) {
        this.size = size;
        this.channels = channels;
        this.w = new HammingWindow(size);
    }

    public DFTProcessor(int size) {
        this(size, 1);
    }

    public void processFrame(double[][] srcBuf, int srcOff, Complex[][][] dstBuf, int dstOff, int computeTo) {
        int f = 0;
        while (f < this.channels) {
            int m = 0;
            while (m < this.size) {
                Complex cx = new Complex();
                double real = 0.0;
                double img = 0.0;
                if (m == 0) {
                    int n = 0;
                    while (n < this.size) {
                        real += this.w.getScale(n) * srcBuf[srcOff + n][f];
                        ++n;
                    }
                } else {
                    double argM = Math.PI * 2 * (double)m;
                    int n = 0;
                    while (n < this.size) {
                        double x = this.w.getScale(n) * srcBuf[srcOff + n][f];
                        double arg = argM * (double)n / (double)this.size;
                        real += x * Math.cos(arg);
                        img -= x * Math.sin(arg);
                        ++n;
                    }
                }
                cx.real = real;
                cx.img = img;
                dstBuf[dstOff][f][m] = cx;
                ++m;
            }
            ++f;
        }
    }

    public void process(double[] srcBuf, int srcOff, int len, Complex[] dstBuf, int dstOff) {
        if (len % this.size != 0) {
            throw new IllegalArgumentException("Values to process must be multiple of frame size");
        }
        int frames = len / this.size;
        if (dstBuf == null) {
            dstBuf = new Complex[len];
        } else if (dstBuf.length < dstOff + len) {
            throw new IllegalArgumentException("Destination buffer to small");
        }
        int f = 0;
        while (f < frames) {
            int m = 0;
            while (m < this.size) {
                Complex cx = new Complex();
                double real = 0.0;
                double img = 0.0;
                if (m == 0) {
                    int n = 0;
                    while (n < this.size) {
                        real += srcBuf[n + f * this.size];
                        ++n;
                    }
                } else {
                    double argM = Math.PI * 2 * (double)m;
                    int n = 0;
                    while (n < this.size) {
                        double x = srcBuf[n + f * this.size];
                        double arg = argM * (double)n / (double)this.size;
                        real += x * Math.cos(arg);
                        img -= x * Math.sin(arg);
                        ++n;
                    }
                }
                cx.real = real;
                cx.img = img;
                dstBuf[m] = cx;
                ++m;
            }
            ++f;
        }
    }
}

