/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net.http;

import ipsk.net.UploadCache;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpUploadCache
extends UploadCache {
    private Logger logger;
    private int responseCode = 0;
    private Vector<String> sessionCookies = new Vector();
    private boolean acceptCookies = false;

    public HttpUploadCache() {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logger.setLevel(Level.FINEST);
        this.bufSize = DEFAULT_BUFSIZE;
        this.buffer = new byte[this.bufSize];
        this.totalLength = 0L;
        this.toUploadLength = 0L;
        this.guessedToUploadLength = 0L;
        this.holdLength = 0L;
        this.holdSize = 0L;
        this.totalUploadLength = 0L;
        this.connectedTimeInMillis = 0L;
        this.byteRate = 0.0f;
        this.idle = true;
        this.synced = true;
        this.requestMethod = "POST";
    }

    public void setSessionCookies(String[] sessionCookies) {
        int i = 0;
        while (i < sessionCookies.length) {
            this.sessionCookies.add(sessionCookies[i]);
            ++i;
        }
    }

    private boolean tryConnect() {
        int retryCount = 0;
        int idleCount = 0;
        do {
            this.getNextUpload();
            while (this.currentUpload == null && this.running) {
                this.fireFinished();
                try {
                    Thread.sleep(ON_IDLE_DELAY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++idleCount;
                this.getNextUpload();
            }
            if (!this.running) {
                return false;
            }
            this.idle = false;
            this.fireTryConnect();
            this.logger.fine("Try connect...");
            try {
                this.connection = this.currentStream.getUrl().openConnection();
                if (this.sessionCookies != null) {
                    int i = 0;
                    while (i < this.sessionCookies.size()) {
                        this.connection.addRequestProperty("Cookie", this.sessionCookies.get(i));
                        ++i;
                    }
                    this.connection.setAllowUserInteraction(true);
                }
                long contentLength = this.currentStream.getLength();
                this.logger.info("Content length of upload: " + contentLength);
                if (contentLength > 0L && contentLength <= Integer.MAX_VALUE) {
                    ((HttpURLConnection)this.connection).setFixedLengthStreamingMode((int)contentLength);
                }
                this.connection.addRequestProperty("Content-length", new Long(this.currentStream.getLength()).toString());
                this.connection.setDoOutput(true);
                if (this.connection instanceof HttpURLConnection) {
                    HttpURLConnection httpConn = (HttpURLConnection)this.connection;
                    httpConn.setRequestMethod(this.requestMethod);
                    String mimeType = this.currentStream.getMimeType();
                    if (mimeType != null) {
                        httpConn.setRequestProperty("Content-type", mimeType);
                    } else {
                        httpConn.setRequestProperty("Content-type", "application/octet-stream");
                    }
                }
                this.connection.connect();
            }
            catch (IOException e) {
                this.responseMessage = new String("Cannot connect. Retry # " + retryCount);
                this.logger.warning(String.valueOf(this.responseMessage) + " " + e.getLocalizedMessage());
                this.fireStateChanged(null);
                if (!this.running) break;
                try {
                    Thread.sleep(CONNECT_RETRY_DELAY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++retryCount <= DEFAULT_CONNECT_RETRIES) continue;
                this.responseMessage = new String("Cannot connect.");
                this.fireStateChanged(null);
                this.running = false;
                break;
            }
            this.connected = true;
            this.logger.fine("Connected.");
            this.fireConnected();
            return true;
        } while (this.running);
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [43[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isAcceptCookies() {
        return this.acceptCookies;
    }

    public void setAcceptCookies(boolean b) {
        this.acceptCookies = b;
    }
}

