/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class JMultiSplitPane
extends JLayeredPane
implements MouseListener,
MouseMotionListener {
    public static final boolean DEBUG = false;
    private ArrayList<Division> divisions;
    private ArrayList<JSeparator> seperators;
    private Component draggedSeparator;

    public JMultiSplitPane() {
        this.setLayout(null);
        this.divisions = new ArrayList();
        this.seperators = new ArrayList();
    }

    @Override
    public synchronized Component add(Component c) {
        super.add(c);
        Division newDiv = new Division(c);
        this.divisions.add(newDiv);
        int cs = this.divisions.size();
        double dCs = cs;
        double divWeight = 1.0 / dCs;
        double divider = dCs / (dCs - 1.0);
        int i = 0;
        while (i < cs - 1) {
            Division d = this.divisions.get(i);
            d.setWeight(d.getWeight() / divider);
            ++i;
        }
        newDiv.setWeight(divWeight);
        if (this.divisions.size() > 1) {
            JSeparator sep = new JSeparator();
            super.add(sep);
            this.seperators.add(sep);
            this.setLayer(sep, JLayeredPane.PALETTE_LAYER);
            sep.setCursor(new Cursor(8));
            sep.addMouseListener(this);
            sep.addMouseMotionListener(this);
        }
        this.revalidate();
        return c;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.divisions.clear();
        this.seperators.clear();
    }

    @Override
    public synchronized void remove(Component c) {
        Division divToRemove = null;
        int divs = this.divisions.size();
        int i = 0;
        while (i < divs) {
            Division d = this.divisions.get(i);
            if (d.getComponent().equals(c)) {
                int seps;
                divToRemove = d;
                int sepIndex = i - 1;
                if (sepIndex < 0) {
                    sepIndex = 0;
                }
                if ((seps = this.seperators.size()) > sepIndex) {
                    JSeparator s = this.seperators.remove(sepIndex);
                    s.removeMouseListener(this);
                    s.removeMouseMotionListener(this);
                    super.remove(s);
                }
                this.divisions.remove(divToRemove);
                super.remove(c);
                break;
            }
            ++i;
        }
        if (divToRemove != null) {
            double totalDistributableWeight = divToRemove.getWeight();
            divs = this.divisions.size();
            double distributableWeight = totalDistributableWeight / (double)divs;
            int i2 = 0;
            while (i2 < divs) {
                Division d = this.divisions.get(i2);
                d.setWeight(d.getWeight() + distributableWeight);
                ++i2;
            }
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Object object = this.getParent().getTreeLock();
        synchronized (object) {
            int y = 0;
            int width = this.getWidth();
            int height = this.getHeight();
            if (width <= 0 || height <= 0) {
                return;
            }
            int compsLen = this.divisions.size();
            int totalSepHeight = 0;
            int i = 0;
            while (i < compsLen - 1) {
                Division d = this.divisions.get(i);
                Component c = d.getComponent();
                JSeparator s = this.seperators.get(i);
                if (c.isVisible()) {
                    totalSepHeight += s.getPreferredSize().height;
                }
                ++i;
            }
            int distributableHeight = height - totalSepHeight;
            double totalWeight = 0.0;
            double visibleWeight = 0.0;
            int i2 = 0;
            while (i2 < compsLen) {
                Division d = this.divisions.get(i2);
                Component c = d.getComponent();
                double weight = d.getWeight();
                totalWeight += weight;
                if (c.isVisible()) {
                    visibleWeight += weight;
                }
                ++i2;
            }
            double visibleWeightFactor = totalWeight / visibleWeight;
            int i3 = 0;
            while (i3 < compsLen) {
                Division d = this.divisions.get(i3);
                Component c = d.getComponent();
                boolean visible = c.isVisible();
                double weight = d.getWeight();
                int prefHeight = 0;
                if (visible) {
                    prefHeight = (int)(weight * visibleWeightFactor * (double)distributableHeight);
                }
                if (prefHeight > distributableHeight) {
                    prefHeight = distributableHeight;
                }
                c.setBounds(0, y, width, prefHeight);
                c.doLayout();
                y += prefHeight;
                if (i3 < compsLen - 1) {
                    JSeparator s = this.seperators.get(i3);
                    int sHeight = 0;
                    if (visible) {
                        sHeight = s.getPreferredSize().height;
                    }
                    s.setBounds(0, y, width, sHeight);
                    y += sHeight;
                }
                ++i3;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.setCursor(new Cursor(8));
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.draggedSeparator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (this.draggedSeparator != null) {
            int i = 0;
            while (i < this.seperators.size()) {
                JSeparator s = this.seperators.get(i);
                if (s == this.draggedSeparator) {
                    ArrayList<Division> arrayList = this.divisions;
                    synchronized (arrayList) {
                        Division dAbove = this.divisions.get(i);
                        Component cAbove = dAbove.getComponent();
                        double cAboveWeight = dAbove.getWeight();
                        Rectangle cAboveBounds = cAbove.getBounds();
                        int cAboveHeight = s.getY() - cAboveBounds.y;
                        if (cAboveHeight < 0) {
                            cAboveHeight = 0;
                        }
                        Division dBelow = this.divisions.get(i + 1);
                        Component cBelow = dBelow.getComponent();
                        double cBelowWeight = dBelow.getWeight();
                        Rectangle cBelowBounds = cBelow.getBounds();
                        int y = s.getY() + s.getHeight();
                        int cBelowHeight = cBelowBounds.y + cBelowBounds.height - y;
                        if (cBelowHeight < 0) {
                            cBelowHeight = 0;
                        }
                        double divisonsHeight = cAboveHeight + cBelowHeight;
                        double weights = cAboveWeight + cBelowWeight;
                        double newAboveWeight = weights * ((double)cAboveHeight / divisonsHeight);
                        dAbove.setWeight(newAboveWeight);
                        dBelow.setWeight(weights - newAboveWeight);
                    }
                }
                ++i;
            }
        }
        this.draggedSeparator = null;
        this.revalidate();
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        int minY = 0;
        int maxY = 0;
        Component s = arg0.getComponent();
        int i = 0;
        while (i < this.seperators.size()) {
            if (s == this.seperators.get(i)) {
                if (i == 0) {
                    minY = 0;
                } else {
                    JSeparator sAbove = this.seperators.get(i - 1);
                    minY = sAbove.getY() + sAbove.getHeight();
                }
                if (i == this.seperators.size() - 1) {
                    maxY = this.getHeight() - s.getHeight();
                    break;
                }
                JSeparator sBelow = this.seperators.get(i + 1);
                maxY = sBelow.getY() - s.getHeight();
                break;
            }
            ++i;
        }
        int reqY = s.getY() + arg0.getY();
        if (reqY < minY) {
            reqY = minY;
        }
        if (reqY > maxY) {
            reqY = maxY;
        }
        arg0.getComponent().setLocation(0, reqY);
        this.draggedSeparator = s;
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        GridBagConstraints c = new GridBagConstraints();
        Container content = f.getContentPane();
        content.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.weightx = 2.0;
        c.weighty = 2.0;
        c.fill = 1;
        final JMultiSplitPane msp = new JMultiSplitPane();
        final JPanel p0 = new JPanel();
        p0.setBackground(Color.RED);
        p0.setPreferredSize(new Dimension(200, 30));
        final JPanel p1 = new JPanel();
        p1.setPreferredSize(new Dimension(200, 60));
        p1.setBackground(Color.GREEN);
        final JPanel p2 = new JPanel();
        p2.setPreferredSize(new Dimension(200, 60));
        p2.setBackground(Color.YELLOW);
        content.add((Component)msp, c);
        final JCheckBox cb0 = new JCheckBox("0");
        cb0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (cb0.isSelected()) {
                    msp.add(p0);
                } else {
                    msp.remove(p0);
                }
            }
        });
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.fill = 0;
        content.add((Component)cb0, c);
        final JCheckBox cb1 = new JCheckBox("1");
        cb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (cb1.isSelected()) {
                    msp.add(p1);
                } else {
                    msp.remove(p1);
                }
            }
        });
        ++c.gridx;
        content.add((Component)cb1, c);
        final JCheckBox cb2 = new JCheckBox("2");
        cb2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (cb2.isSelected()) {
                    msp.add(p2);
                } else {
                    msp.remove(p2);
                }
            }
        });
        ++c.gridx;
        content.add((Component)cb2, c);
        f.pack();
        f.setVisible(true);
    }

    public class Division {
        private Component component;
        private double weight;

        public Division(Component c) {
            this.component = c;
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double weight) {
            this.weight = weight;
        }

        public Component getComponent() {
            return this.component;
        }
    }
}

