/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.action.tree;

import ipsk.swing.action.tree.ActionList;
import ipsk.util.LocalizableMessage;

public class ActionFolder
extends ActionList {
    public static final String FILE_FOLDER_KEY = "file";
    public static final String EDIT_FOLDER_KEY = "edit";
    public static final String VIEW_FOLDER_KEY = "view";
    public static final String NAVIGATE_FOLDER_KEY = "navigate";
    public static final String HELP_FOLDER_KEY = "help";
    private boolean isTopLevel = false;

    public ActionFolder(String key, LocalizableMessage displayName) {
        this(false, key, displayName);
    }

    public ActionFolder(String key) {
        super(key);
        this.isTopLevel = false;
    }

    public ActionFolder(boolean isTopLevel, String key, LocalizableMessage displayName) {
        super(key, displayName);
        this.isTopLevel = isTopLevel;
    }

    public static ActionFolder buildTopLevelFolder(String key) {
        String m = key.substring(0, 1);
        m = m.toUpperCase();
        m = m.concat(key.substring(1));
        LocalizableMessage displayName = new LocalizableMessage(m);
        return new ActionFolder(true, key, displayName);
    }

    public Object clone() {
        return new ActionFolder(this.isTopLevel, this.key, this.displayName);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ActionFolder)) {
            return false;
        }
        ActionFolder oAF = (ActionFolder)o;
        if (this.key == null) {
            return false;
        }
        return this.key.equals(oAF.getKey());
    }
}

