/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import ipsk.text.quoting.TextPart;
import java.util.ArrayList;
import java.util.List;

public class StringTokenizer {
    public static String[] split(String string, char fieldSeparator) {
        return StringTokenizer.split(string, fieldSeparator, false);
    }

    public static String[] split(String string, char fieldSeparator, boolean trim) {
        if (string == null) {
            return null;
        }
        ArrayList<String> cols = new ArrayList<String>();
        int i = 0;
        int fieldSepIndex = -1;
        do {
            String newCol;
            if ((fieldSepIndex = string.indexOf(fieldSeparator, i)) != -1) {
                newCol = string.substring(i, fieldSepIndex);
                if (trim) {
                    newCol = newCol.trim();
                }
                cols.add(newCol);
                i = fieldSepIndex + 1;
                continue;
            }
            newCol = string.substring(i);
            if (trim) {
                newCol = newCol.trim();
            }
            cols.add(newCol);
        } while (fieldSepIndex != -1);
        return cols.toArray(new String[0]);
    }

    public static String[] split(List<TextPart> textPartList, char fieldSeparator, boolean trim) {
        ArrayList<String> cols = new ArrayList<String>();
        StringBuffer currentCol = new StringBuffer();
        for (TextPart tp : textPartList) {
            String string = tp.getText();
            boolean quoted = tp.isQuoted();
            if (quoted) {
                currentCol.append(string);
                continue;
            }
            int i = 0;
            int fieldSepIndex = -1;
            do {
                if ((fieldSepIndex = string.indexOf(fieldSeparator, i)) != -1) {
                    String colPart = string.substring(i, fieldSepIndex);
                    currentCol.append(colPart);
                    String newCol = currentCol.toString();
                    currentCol = new StringBuffer();
                    if (trim) {
                        newCol = newCol.trim();
                    }
                    cols.add(newCol);
                    i = fieldSepIndex + 1;
                    continue;
                }
                currentCol.append(string.substring(i));
            } while (fieldSepIndex != -1);
        }
        String newCol = currentCol.toString();
        currentCol = new StringBuffer();
        if (trim) {
            newCol = newCol.trim();
        }
        cols.add(newCol);
        return cols.toArray(new String[0]);
    }

    public static void main(String[] args) {
        String testString = "\ta\t\tb\tc\t";
        String[] tks = StringTokenizer.split(testString, '\t');
        System.out.println(String.valueOf(tks.length) + " tokens:");
        String[] stringArray = tks;
        int n = tks.length;
        int n2 = 0;
        while (n2 < n) {
            String tk = stringArray[n2];
            System.out.println(tk);
            ++n2;
        }
        stringArray = "ABC ,DEF, bla".trim().split("\\s*,\\s*");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            System.out.println("Token: __" + ss + "__");
            ++n2;
        }
    }
}

