/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import java.util.Arrays;

public class TableTextFormats {
    public static Profile matchesProfile(UnitSeparator unitSeparator, RecordSeparator recordSeparator, GroupSeparator groupSeparator) {
        Profile[] profileArray = Profile.values();
        int n = profileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Profile prf = profileArray[n2];
            boolean matches = true;
            if (unitSeparator != null) {
                matches &= unitSeparator.value == prf.getFieldSeparator().value;
            }
            if (recordSeparator != null) {
                matches &= Arrays.equals(recordSeparator.value, prf.getRecordSeparator().value());
            }
            if (groupSeparator != null) {
                matches &= Arrays.equals(groupSeparator.value, prf.getGroupSeparator().value());
            }
            if (matches) {
                return prf;
            }
            ++n2;
        }
        return null;
    }

    public static enum GroupSeparator {
        LF(new char[]{'\n'}, "New line (UNIX end of line)"),
        CRLF(new char[]{'\r', '\n'}, "Carriage return/line feed (Windows end of line)"),
        CR(new char[]{'\r'}, "Carriage return"),
        GS(new char[]{'\u001e'}, " GS  (group separator)");

        private final char[] value;
        private final String description;

        private GroupSeparator(char[] value, String description) {
            this.value = value;
            this.description = description;
        }

        public char[] value() {
            return this.value;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum Profile {
        ASCII_UNICODE("ASCII/Unicode", UnitSeparator.US, RecordSeparator.RS, GroupSeparator.GS),
        TAB_SEP_WIN("Tab separated Windows", UnitSeparator.TAB, RecordSeparator.CRLF, GroupSeparator.CRLF),
        TAB_SEP_UNIX("Tab separated UNIX", UnitSeparator.TAB, RecordSeparator.LF, GroupSeparator.LF),
        CSV("Comma separated", UnitSeparator.COMMA, RecordSeparator.CRLF, GroupSeparator.CRLF);

        private final UnitSeparator unitSeparator;
        private final RecordSeparator recordSeparator;
        private final GroupSeparator groupSeparator;
        private final String description;

        private Profile(String description, UnitSeparator unitSeparator, RecordSeparator recordSeparator, GroupSeparator groupSeparator) {
            this.description = description;
            this.unitSeparator = unitSeparator;
            this.recordSeparator = recordSeparator;
            this.groupSeparator = groupSeparator;
        }

        public String toString() {
            return this.description;
        }

        public UnitSeparator getFieldSeparator() {
            return this.unitSeparator;
        }

        public RecordSeparator getRecordSeparator() {
            return this.recordSeparator;
        }

        public GroupSeparator getGroupSeparator() {
            return this.groupSeparator;
        }
    }

    public static enum RecordSeparator {
        LF(new char[]{'\n'}, "New line (UNIX end of line)"),
        CRLF(new char[]{'\r', '\n'}, "Carriage return/line feed (Windows end of line)"),
        CR(new char[]{'\r'}, "Carriage return"),
        RS(new char[]{'\u001e'}, " RS  (record separator)");

        private final char[] value;
        private final String description;

        private RecordSeparator(char[] value, String description) {
            this.value = value;
            this.description = description;
        }

        public char[] value() {
            return this.value;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum UnitSeparator {
        TAB('\t', "Tabulator"),
        COMMA(',', "',' Comma"),
        SEMICOLON(';', "';' Semicolon"),
        COLON(':', "':' Colon"),
        HYPHEN('-', "'-' Hyphen"),
        BLANK(' ', "' ' Blank"),
        US('\u001f', " US  (unit separator)");

        private final char value;
        private final String description;

        private UnitSeparator(char value, String description) {
            this.value = value;
            this.description = description;
        }

        public char value() {
            return this.value;
        }

        public String toString() {
            return this.description;
        }
    }
}

