/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;

public class TimeFormat
extends Format {
    public static Format FIXED_SECONDS_MS_TIME_FORMAT = new TimeFormat(3, "########0.000");
    private int divider;
    private double secondsDivider;
    private DecimalFormat format;
    public static final int NANOSECONDS = 0;
    public static final int MICROSECONDS = 1;
    public static final int MILLISECONDS = 2;
    public static final int SECONDS = 3;
    private FieldPosition zeroFieldPosition;

    public TimeFormat(int unit, String pattern) {
        this.divider = (int)Math.pow(1000.0, unit);
        this.secondsDivider = Math.pow(1000.0, unit - 3);
        this.format = new DecimalFormat(pattern);
        this.zeroFieldPosition = new FieldPosition(0);
    }

    private String createCharSequence(char c, int count) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < count) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public Object parseObject(String timeStr, ParsePosition parsePosition) {
        return null;
    }

    @Override
    public StringBuffer format(Object arg0, StringBuffer arg1, FieldPosition arg2) {
        StringBuffer sb = new StringBuffer();
        if (arg0 == null) {
            return this.format.format(Double.NaN, sb, (FieldPosition)null);
        }
        if (arg0 instanceof Double) {
            double val = (Double)arg0;
            double dval = val / this.secondsDivider;
            return this.format.format(dval, sb, this.zeroFieldPosition);
        }
        if (arg0 instanceof Long) {
            long val = (Long)arg0;
            double dval = (double)val / (double)this.divider;
            return this.format.format(dval, sb, this.zeroFieldPosition);
        }
        return null;
    }

    public static void main(String[] args) {
        TimeFormat mtf = new TimeFormat(2, "######0.000");
        String result = mtf.format(new Double(0.8));
        System.out.println(result);
        try {
            System.out.println(mtf.parseObject(result));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

