/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.zip;

import ipsk.awt.ProgressWorker;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.swing.JProgressDialogPanel;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class UnzipWorker
extends ProgressWorker {
    public static final boolean DEFAULT_LIMIT_TO_32BIT_SIZES = false;
    public static long MAX_32BIT_ZIP_FILE_SIZE = 0xFFFFFFFFL;
    public static int MAX_32BIT_ZIP_FILE_ENTRIES = 65536;
    public static int DEFAULT_BUF_SIZE = 32768;
    private int bufferSize = DEFAULT_BUF_SIZE;
    private long sizeDone = 0L;
    private File trgDir;
    private File sourceZipFile;
    private boolean limitTo32bitSizes;
    private boolean overwrite = false;
    private boolean trgDirCreated = false;

    @Override
    public void open() throws WorkerException {
        this.progressStatus.setLength(ProgressStatus.LENGTH_UNKNOWN);
        super.open();
    }

    public boolean isLimitTo32bitSizes() {
        return this.limitTo32bitSizes;
    }

    public void setLimitTo32bitSizes(boolean limitTo32bitSizes) {
        this.limitTo32bitSizes = limitTo32bitSizes;
    }

    @Override
    public void doWork() throws WorkerException {
        this.progressStatus.setMessage(new LocalizableMessage("Calculating ZIP archive size..."));
        long length = 0L;
        try {
            length = this.calcZipSize();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new WorkerException("Could not determine ZIP file size", e1);
        }
        this.progressStatus.setLength(length);
        this.fireProgressEvent();
        try {
            this.unpack();
        }
        catch (IOException e) {
            throw new WorkerException(e);
        }
    }

    private long calcZipSize() throws IOException {
        long totalSize = 0L;
        ZipFile zipFile = new ZipFile(this.sourceZipFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                if (this.hasCancelRequest()) {
                    this.progressStatus.setMessage(new LocalizableMessage("Canceled !"));
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    return -1L;
                }
                try {
                    ZipEntry entry = entries.nextElement();
                    long entrySize = entry.getSize();
                    totalSize += entrySize;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        return totalSize;
    }

    /*
     * Exception decompiling
     */
    private void unpack() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP], 2[TRYBLOCK]], but top level block is 17[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getSizeDone() {
        return this.sizeDone;
    }

    public void setSizeDone(long sizeDone) {
        this.sizeDone = sizeDone;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public File getTrgDir() {
        return this.trgDir;
    }

    public void setTrgDir(File trgDir) {
        this.trgDir = trgDir;
    }

    public File getSourceZipFile() {
        return this.sourceZipFile;
    }

    public void setSourceZipFile(File sourceZipFile) {
        this.sourceZipFile = sourceZipFile;
    }

    public static void main(String[] args) {
        UnzipWorker unzipWorker = new UnzipWorker();
        unzipWorker.setSourceZipFile(new File(args[0]));
        unzipWorker.setTrgDir(new File(args[1]));
        JProgressDialogPanel progressDialog = new JProgressDialogPanel(unzipWorker, "Unzip test", "Unpacking...");
        try {
            unzipWorker.open();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        unzipWorker.start();
        JFrame f = new JFrame("Unzip test");
        Object val = progressDialog.showDialog(f);
        try {
            unzipWorker.close();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        Worker.State ws = unzipWorker.getStatus();
        if (!Worker.State.DONE.equals((Object)ws)) {
            if (Worker.State.CANCELLED.equals((Object)ws)) {
                JOptionPane.showMessageDialog(f, "Unzip canceled.");
                System.exit(1);
            } else {
                JOptionPane.showMessageDialog(f, "Unzip error!");
                System.exit(-1);
            }
        }
        System.exit(0);
    }
}

