/*
 * Decompiled with CFR 0.152.
 */
package ipsk.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class TrackLayout
implements LayoutManager {
    private final boolean DEBUG = false;
    private int width = 0;
    private boolean useFixedWidth = true;

    public TrackLayout() {
    }

    public TrackLayout(int width) {
        this.width = width;
    }

    public synchronized void setFixedWidth(int width) {
        this.width = width;
    }

    public int getFixedWidth() {
        return this.width;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            Component[] cs = parent.getComponents();
            int preferredHeight = 0;
            int i = 0;
            while (i < cs.length) {
                Dimension d = cs[i].getPreferredSize();
                if (d != null && d.height > 0) {
                    preferredHeight += d.height;
                }
                ++i;
            }
            preferredHeight += insets.top;
            int preferredWidth = 0;
            preferredWidth = this.useFixedWidth ? this.width : parent.getSize().width;
            return new Dimension(preferredWidth + insets.left + insets.right, preferredHeight += insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            Component[] cs = parent.getComponents();
            int preferredHeight = 0;
            int i = 0;
            while (i < cs.length) {
                Dimension d = cs[i].getMinimumSize();
                if (d != null && d.height > 0) {
                    preferredHeight += d.height;
                }
                ++i;
            }
            preferredHeight += insets.top;
            return new Dimension(insets.left + insets.right, preferredHeight += insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int y = 0;
            int parentHeight = parent.getSize().height;
            int parentWidth = parent.getSize().width;
            int layoutWidth = this.useFixedWidth ? this.width : parentWidth - insets.left - insets.right;
            int minimumLayoutHeight = this.minimumLayoutSize((Container)parent).height;
            int preferredLayoutHeight = this.preferredLayoutSize((Container)parent).height;
            if (minimumLayoutHeight >= parentHeight) {
                Component[] cs = parent.getComponents();
                int i = 0;
                while (i < cs.length) {
                    int mHeight = cs[i].getMinimumSize().height;
                    cs[i].setBounds(insets.left, y + insets.top, layoutWidth, mHeight);
                    y += mHeight;
                    ++i;
                }
            } else if (preferredLayoutHeight > parent.getSize().height) {
                int distributableHeight = parentHeight - minimumLayoutHeight;
                Component[] cs = parent.getComponents();
                int componentsWhichLikeSpace = 0;
                int i = 0;
                while (i < cs.length) {
                    int pHeight = cs[i].getPreferredSize().height;
                    int mHeight = cs[i].getMinimumSize().height;
                    if (pHeight > mHeight) {
                        ++componentsWhichLikeSpace;
                    }
                    ++i;
                }
                int eachDistributableSpace = 0;
                if (componentsWhichLikeSpace > 0) {
                    eachDistributableSpace = distributableHeight / componentsWhichLikeSpace;
                }
                int i2 = 0;
                while (i2 < cs.length) {
                    int pHeight = cs[i2].getPreferredSize().height;
                    int mHeight = cs[i2].getMinimumSize().height;
                    int height = pHeight > mHeight ? mHeight + eachDistributableSpace : mHeight;
                    cs[i2].setBounds(insets.left, y + insets.top, layoutWidth, height);
                    y += height;
                    ++i2;
                }
            } else {
                int distributableHeight = parentHeight - preferredLayoutHeight;
                Component[] cs = parent.getComponents();
                int componentsWhichLikeSpace = 0;
                int i = 0;
                while (i < cs.length) {
                    int pHeight = cs[i].getPreferredSize().height;
                    int mHeight = cs[i].getMinimumSize().height;
                    if (pHeight > mHeight) {
                        ++componentsWhichLikeSpace;
                    }
                    ++i;
                }
                int eachDistributableSpace = 0;
                if (componentsWhichLikeSpace > 0) {
                    eachDistributableSpace = distributableHeight / componentsWhichLikeSpace;
                }
                int i3 = 0;
                while (i3 < cs.length) {
                    int pHeight = cs[i3].getPreferredSize().height;
                    int mHeight = cs[i3].getMinimumSize().height;
                    int height = pHeight > mHeight ? pHeight + eachDistributableSpace : pHeight;
                    cs[i3].setBounds(insets.left, y + insets.top, this.width, height);
                    y += height;
                    ++i3;
                }
            }
        }
    }

    public boolean isUseFixedWidth() {
        return this.useFixedWidth;
    }

    public void setUseFixedWidth(boolean useFixedWidth) {
        this.useFixedWidth = useFixedWidth;
    }
}

