/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.util.LocalizableMessage;

public class FilenameValidator {
    public static String[] RESERVED_NAMES = new String[]{".", ".."};
    public static char[] RESERVED_CHARS_WINDOWS = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*'};
    public static String[] RESERVED_NAMES_WINDOWS = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    public static char[] RESERVED_CHARS_UNIX;

    static {
        char[] cArray = new char[2];
        cArray[1] = 47;
        RESERVED_CHARS_UNIX = cArray;
    }

    public static ValidationResult validateFileNameCharacters(String string) {
        char[] fileNameChars;
        char[] cArray = fileNameChars = string.toCharArray();
        int n = fileNameChars.length;
        int n2 = 0;
        while (n2 < n) {
            char rc;
            char fnc = cArray[n2];
            char[] cArray2 = RESERVED_CHARS_WINDOWS;
            int n3 = RESERVED_CHARS_WINDOWS.length;
            int n4 = 0;
            while (n4 < n3) {
                rc = cArray2[n4];
                if (rc == fnc) {
                    return new ValidationResult("contains reserved character: \"" + rc + "\"");
                }
                ++n4;
            }
            cArray2 = RESERVED_CHARS_UNIX;
            n3 = RESERVED_CHARS_UNIX.length;
            n4 = 0;
            while (n4 < n3) {
                rc = cArray2[n4];
                if (rc == fnc) {
                    return new ValidationResult("contains reserved character: \"" + rc + "\"");
                }
                ++n4;
            }
            Character.isISOControl(fnc);
            ++n2;
        }
        return new ValidationResult(true);
    }

    public static ValidationResult validate(String fileName) {
        if (fileName == null) {
            throw new NullPointerException();
        }
        String[] stringArray = RESERVED_NAMES;
        int n = RESERVED_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String resName = stringArray[n2];
            if (fileName.equals(resName)) {
                return new ValidationResult("reserved name: " + fileName);
            }
            ++n2;
        }
        ValidationResult vrc = FilenameValidator.validateFileNameCharacters(fileName);
        if (!vrc.isValid()) {
            return vrc;
        }
        String fileNameBody = fileName;
        int extPos = fileName.lastIndexOf(".");
        if (extPos > 0) {
            fileNameBody = fileName.substring(0, extPos);
        }
        String[] stringArray2 = RESERVED_NAMES_WINDOWS;
        int n3 = RESERVED_NAMES_WINDOWS.length;
        int n4 = 0;
        while (n4 < n3) {
            String resNameWindows = stringArray2[n4];
            if (fileNameBody.equals(resNameWindows)) {
                return new ValidationResult("reserved Windows filename: " + resNameWindows);
            }
            ++n4;
        }
        char lastChar = fileName.charAt(fileName.length() - 1);
        if (lastChar == ' ' || lastChar == '.') {
            return new ValidationResult("on Windows last char of filename should not be a space or period");
        }
        return new ValidationResult(true);
    }

    public static class ValidationResult {
        private LocalizableMessage message;
        private boolean valid;

        public ValidationResult(boolean valid) {
            this(valid, null);
        }

        public ValidationResult(String message) {
            this(false, new LocalizableMessage(message));
        }

        public ValidationResult(boolean valid, LocalizableMessage message) {
            this.valid = valid;
            this.message = message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public LocalizableMessage getMessage() {
            return this.message;
        }

        public static enum Type {
            OK,
            VALID_NOT_RECOMMENDED,
            INVALID;

        }
    }
}

