/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math.bool;

import ipsk.util.ObjectNullComparator;

public class BoolExpr
implements Cloneable {
    public static final String GREATER_THEN = ">";
    public static final String GREATER_EQUAL = ">=";
    public static final String LESS_THEN = "<";
    public static final String LESS_EQUAL = "<=";
    public static String EQUAL = "=";
    public static String NOT_EQUAL = "<>";
    public static String AND = "AND";
    public static String OR = "OR";
    protected Object operand0;
    protected Object operator;
    protected Object operand1;

    public Object getOperand0() {
        return this.operand0;
    }

    public void setOperand0(Object operand0) {
        this.operand0 = operand0;
    }

    public Object getOperand1() {
        return this.operand1;
    }

    public void setOperand1(Object operand1) {
        this.operand1 = operand1;
    }

    public Object getOperator() {
        return this.operator;
    }

    public void setOperator(Object operator) {
        this.operator = operator;
    }

    public boolean isExpression() {
        String[] exprOps = BoolExpr.getExprOperators();
        int i = 0;
        while (i < exprOps.length) {
            if (exprOps[i].equals(this.operator)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getExprOperators() {
        return new String[]{EQUAL, NOT_EQUAL, GREATER_THEN, GREATER_EQUAL, LESS_THEN, LESS_EQUAL};
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BoolExpr)) {
            return false;
        }
        BoolExpr be = (BoolExpr)o;
        return ObjectNullComparator.areEqual(be.getOperand0(), this.operand0) && ObjectNullComparator.areEqual(be.getOperator(), this.operator) && ObjectNullComparator.areEqual(be.getOperand1(), this.operand1);
    }

    protected Object cloneType(Object o) throws CloneNotSupportedException {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return new String((String)o);
        }
        if (o instanceof Byte) {
            return (byte)((Byte)o);
        }
        if (o instanceof Short) {
            return (short)((Short)o);
        }
        if (o instanceof Integer) {
            return (int)((Integer)o);
        }
        if (o instanceof Long) {
            return (long)((Long)o);
        }
        if (o instanceof Float) {
            return Float.valueOf(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return (double)((Double)o);
        }
        throw new CloneNotSupportedException();
    }

    public Object clone() throws CloneNotSupportedException {
        BoolExpr clone = new BoolExpr();
        if (this.operand0 != null && this.operand0 instanceof BoolExpr) {
            clone.setOperand0(((BoolExpr)this.operand0).clone());
        } else {
            clone.setOperand0(this.cloneType(this.operand0));
        }
        clone.setOperator(this.cloneType(this.operator));
        if (this.operand1 != null && this.operand1 instanceof BoolExpr) {
            clone.setOperand1(((BoolExpr)this.operand1).clone());
        } else {
            clone.setOperand1(this.cloneType(this.operand1));
        }
        return clone;
    }
}

