/*
 * Decompiled with CFR 0.152.
 */
package ips.dsp;

public class IIRFilter {
    protected double[] bCoeff;
    protected double[] aCoeff;
    protected double[] bDelayBuf;
    protected double[] aDelayBuf;
    protected double[] delayBuf;

    public IIRFilter(double[] bCoeff, double[] aCoeff) {
        this.bCoeff = bCoeff;
        this.aCoeff = aCoeff;
        this.bDelayBuf = new double[bCoeff.length - 1];
        this.aDelayBuf = new double[aCoeff.length];
    }

    public double step(double in) {
        int i;
        double sum = this.bCoeff[0] * in;
        for (i = 0; i < this.bDelayBuf.length; ++i) {
            sum += this.bCoeff[i + 1] * this.bDelayBuf[i];
        }
        for (i = 0; i < this.aDelayBuf.length - 1; ++i) {
            sum -= this.aCoeff[i + 1] * this.aDelayBuf[i];
        }
        for (i = this.bDelayBuf.length - 1; i > 0; --i) {
            this.bDelayBuf[i] = this.bDelayBuf[i - 1];
        }
        this.bDelayBuf[0] = in;
        for (i = this.aDelayBuf.length - 1; i > 0; --i) {
            this.aDelayBuf[i] = this.aDelayBuf[i - 1];
        }
        this.aDelayBuf[0] = sum /= this.aCoeff[0];
        return sum;
    }
}

