/*
 * Decompiled with CFR 0.152.
 */
package ipsk.awt.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.JTextComponent;

public class AutoFontFamilyManager {
    private List<String> fontFamilies = new ArrayList<String>();
    private String[] preferredFontFamilies;
    private boolean searchOtherFonts = false;

    public String[] getPreferredFontFamilies() {
        return this.preferredFontFamilies;
    }

    public void setPreferredFontFamilies(String[] preferredFontFamilies) {
        this.preferredFontFamilies = preferredFontFamilies;
        this.buildFontFamiliesList();
    }

    public boolean isSearchOtherFonts() {
        return this.searchOtherFonts;
    }

    public void setSearchOtherFonts(boolean searchOtherFonts) {
        this.searchOtherFonts = searchOtherFonts;
        this.buildFontFamiliesList();
    }

    public List<String> getFontFamilies() {
        return this.fontFamilies;
    }

    public AutoFontFamilyManager() {
        this(null, true);
    }

    public AutoFontFamilyManager(String[] fontFamilies) {
        this(fontFamilies, false);
    }

    public AutoFontFamilyManager(String[] preferredFontFamilies, boolean searchOtherFonts) {
        this.preferredFontFamilies = preferredFontFamilies;
        this.searchOtherFonts = searchOtherFonts;
        this.buildFontFamiliesList();
    }

    private void buildFontFamiliesList() {
        GraphicsEnvironment ge;
        if (this.preferredFontFamilies != null) {
            this.fontFamilies.addAll(Arrays.asList(this.preferredFontFamilies));
        }
        if (this.searchOtherFonts && (ge = GraphicsEnvironment.getLocalGraphicsEnvironment()) != null) {
            String[] allFams = ge.getAvailableFontFamilyNames();
            List<String> allFamsList = Arrays.asList(allFams);
            this.fontFamilies.addAll(allFamsList);
        }
    }

    public Font getFontCanDisplay(Font orgFont, String text) {
        Font canFont = null;
        if (orgFont.canDisplayUpTo(text) == -1) {
            canFont = orgFont;
        } else {
            int fStyle = orgFont.getStyle();
            int fSize = orgFont.getSize();
            for (String tFf : this.fontFamilies) {
                Font trialfont = new Font(tFf, fStyle, fSize);
                if (trialfont.canDisplayUpTo(text) != -1) continue;
                canFont = trialfont;
                break;
            }
        }
        return canFont;
    }

    public void applyFontCanDisplay(JTextComponent textComponent) {
        Font canFont;
        Font orgFont;
        String text = textComponent.getText();
        if (text != null && (orgFont = textComponent.getFont()) != null && (canFont = this.getFontCanDisplay(orgFont, text)) != null && !orgFont.equals(canFont)) {
            textComponent.setFont(canFont);
        }
    }
}

