/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math;

import ipsk.math.Complex;
import ipsk.math.HammingWindow;
import ipsk.math.Window;

public class DFTProcessor {
    private int size;
    private int channels;
    private Window w;

    public DFTProcessor(int size, int channels, Window window) {
        this.size = size;
        this.channels = channels;
        this.w = window;
    }

    public DFTProcessor(int size, int channels) {
        this.size = size;
        this.channels = channels;
        this.w = new HammingWindow(size);
    }

    public DFTProcessor(int size) {
        this(size, 1);
    }

    public void processFrame(double[][] srcBuf, int srcOff, Complex[][][] dstBuf, int dstOff, int computeTo) {
        for (int f = 0; f < this.channels; ++f) {
            for (int m = 0; m < this.size; ++m) {
                Complex cx = new Complex();
                double real = 0.0;
                double img = 0.0;
                if (m == 0) {
                    for (int n = 0; n < this.size; ++n) {
                        real += this.w.getScale(n) * srcBuf[srcOff + n][f];
                    }
                } else {
                    double argM = Math.PI * 2 * (double)m;
                    for (int n = 0; n < this.size; ++n) {
                        double x = this.w.getScale(n) * srcBuf[srcOff + n][f];
                        double arg = argM * (double)n / (double)this.size;
                        real += x * Math.cos(arg);
                        img -= x * Math.sin(arg);
                    }
                }
                cx.real = real;
                cx.img = img;
                dstBuf[dstOff][f][m] = cx;
            }
        }
    }

    public void process(double[] srcBuf, int srcOff, int len, Complex[] dstBuf, int dstOff) {
        if (len % this.size != 0) {
            throw new IllegalArgumentException("Values to process must be multiple of frame size");
        }
        int frames = len / this.size;
        if (dstBuf == null) {
            dstBuf = new Complex[len];
        } else if (dstBuf.length < dstOff + len) {
            throw new IllegalArgumentException("Destination buffer to small");
        }
        for (int f = 0; f < frames; ++f) {
            for (int m = 0; m < this.size; ++m) {
                Complex cx = new Complex();
                double real = 0.0;
                double img = 0.0;
                if (m == 0) {
                    for (int n = 0; n < this.size; ++n) {
                        real += srcBuf[n + f * this.size];
                    }
                } else {
                    double argM = Math.PI * 2 * (double)m;
                    for (int n = 0; n < this.size; ++n) {
                        double x = srcBuf[n + f * this.size];
                        double arg = argM * (double)n / (double)this.size;
                        real += x * Math.cos(arg);
                        img -= x * Math.sin(arg);
                    }
                }
                cx.real = real;
                cx.img = img;
                dstBuf[m] = cx;
            }
        }
    }
}

