/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class JRuler
extends JPanel
implements MouseMotionListener,
MouseListener,
ActionListener {
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    private JFrame w;
    private MouseEvent mouseDragstartEvent;
    private JPopupMenu popup;
    private JMenu orientationMenu;
    private JMenuItem north;
    private JMenuItem east;
    private JMenuItem south;
    private JMenuItem west;
    private JMenuItem quit;
    private int orientation = 0;

    public JRuler() {
        this.setBackground(Color.ORANGE);
        this.quit = new JMenuItem("Close");
        this.quit.addActionListener(this);
        this.popup = new JPopupMenu("Pop");
        this.orientationMenu = new JMenu("Orientation");
        this.north = new JMenuItem("North");
        this.north.addActionListener(this);
        this.south = new JMenuItem("South");
        this.south.addActionListener(this);
        this.west = new JMenuItem("West");
        this.west.addActionListener(this);
        this.east = new JMenuItem("East");
        this.east.addActionListener(this);
        this.orientationMenu.add(this.north);
        this.orientationMenu.add(this.south);
        this.orientationMenu.add(this.west);
        this.orientationMenu.add(this.east);
        this.popup.add(this.orientationMenu);
        this.popup.add(this.quit);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        int length = this.orientation == 0 || this.orientation == 2 ? size.width : size.height;
        for (int i = 0; i < length; ++i) {
            if (i % 5 == 0) {
                if (this.orientation == 0) {
                    g.drawLine(i, 0, i, 3);
                } else if (this.orientation == 2) {
                    g.drawLine(i, size.height - 3, i, size.height);
                } else if (this.orientation == 3) {
                    g.drawLine(0, i, 3, i);
                } else if (this.orientation == 1) {
                    g.drawLine(size.width - 3, i, size.width, i);
                }
            }
            if (i % 10 == 0) {
                if (this.orientation == 0) {
                    g.drawLine(i, 0, i, 10);
                } else if (this.orientation == 2) {
                    g.drawLine(i, size.height - 10, i, size.height);
                } else if (this.orientation == 3) {
                    g.drawLine(0, i, 10, i);
                } else if (this.orientation == 1) {
                    g.drawLine(size.width - 10, i, size.width, i);
                }
            }
            if (i % 50 != 0) continue;
            if (this.orientation == 0) {
                g.drawLine(i, 0, i, 20);
                g.drawString(Integer.toString(i), i + 1, 20);
                continue;
            }
            if (this.orientation == 2) {
                g.drawLine(i, size.height - 20, i, size.height);
                g.drawString(Integer.toString(i), i + 1, size.height - 10);
                continue;
            }
            if (this.orientation == 3) {
                g.drawLine(0, i, 20, i);
                g.drawString(Integer.toString(i), 10, i - 1);
                continue;
            }
            if (this.orientation != 1) continue;
            g.drawLine(size.width - 20, i, size.width, i);
            g.drawString(Integer.toString(i), size.width - 32, i - 1);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.orientation == 0 || this.orientation == 2) {
            return new Dimension(1000, 50);
        }
        return new Dimension(50, 800);
    }

    private void createAndShow() {
        this.w = new JFrame();
        this.w.setUndecorated(true);
        this.w.getContentPane().add(this);
        this.w.pack();
        this.w.setVisible(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public static void main(String[] args) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JRuler jr = new JRuler();
                jr.createAndShow();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = this.w.getLocation().x;
        int y = this.w.getLocation().y;
        int deltax = e.getX() - this.mouseDragstartEvent.getX();
        int deltay = e.getY() - this.mouseDragstartEvent.getY();
        this.w.setLocation(x + deltax, y + deltay);
        this.w.toFront();
        this.w.setAlwaysOnTop(true);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseDragstartEvent = e;
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseDragstartEvent = null;
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.quit) {
            this.w.dispose();
            System.exit(0);
        } else if (src == this.north) {
            this.setOrientation(0);
        } else if (src == this.south) {
            this.setOrientation(2);
        } else if (src == this.west) {
            this.setOrientation(3);
        } else if (src == this.east) {
            this.setOrientation(1);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.revalidate();
        this.w.pack();
        this.repaint();
    }
}

