/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.action.tree;

import ipsk.swing.action.tree.ActionFolder;
import ipsk.swing.action.tree.ActionGroup;
import ipsk.swing.action.tree.ActionLeaf;
import ipsk.swing.action.tree.ActionNode;
import ipsk.swing.action.tree.CheckActionLeaf;
import ipsk.swing.action.tree.RadioActionLeaf;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class JMenuBuilder {
    private ActionFolder rootNode;

    public JMenuBuilder(ActionFolder rootNode) {
        this.rootNode = rootNode;
    }

    public JMenuItem buildMenu(ActionLeaf cn2) {
        ActionLeaf al = cn2;
        if (al instanceof CheckActionLeaf) {
            JCheckBoxMenuItem checkMi = new JCheckBoxMenuItem(al);
            return checkMi;
        }
        if (al instanceof RadioActionLeaf) {
            RadioActionLeaf ral = (RadioActionLeaf)al;
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(ral);
            return mi;
        }
        JMenuItem mi = new JMenuItem(al);
        return mi;
    }

    public JMenuItem buildMenu(ActionNode cn2) {
        if (cn2 instanceof ActionFolder) {
            ActionFolder af = (ActionFolder)cn2;
            JMenu menu = new JMenu(af.getDisplayName().localize());
            List<ActionNode> chs = af.getChildren();
            this.addChildren(menu, chs);
            return menu;
        }
        if (cn2 instanceof ActionLeaf) {
            ActionLeaf al = (ActionLeaf)cn2;
            if (al instanceof CheckActionLeaf) {
                JCheckBoxMenuItem checkMi = new JCheckBoxMenuItem(al);
                return checkMi;
            }
            if (al instanceof RadioActionLeaf) {
                RadioActionLeaf ral = (RadioActionLeaf)al;
                JRadioButtonMenuItem mi = new JRadioButtonMenuItem(ral);
                return mi;
            }
            JMenuItem mi = new JMenuItem(al);
            return mi;
        }
        return null;
    }

    private void addChildren(JMenu m, List<ActionNode> ans) {
        int numAns = ans.size();
        boolean separated = true;
        for (int i = 0; i < numAns; ++i) {
            ActionNode an = ans.get(i);
            if (an instanceof ActionFolder) {
                ActionFolder af = (ActionFolder)an;
                JMenu menu = new JMenu(af.getDisplayName().localize());
                List<ActionNode> chAns = af.getChildren();
                this.addChildren(menu, chAns);
                m.add(menu);
                separated = false;
                continue;
            }
            if (an instanceof ActionGroup) {
                ActionGroup ag = (ActionGroup)an;
                if (!separated) {
                    m.addSeparator();
                    separated = true;
                }
                List<ActionNode> chAns = ag.getChildren();
                this.addChildren(m, chAns);
                if (i >= numAns - 1) continue;
                m.addSeparator();
                separated = true;
                continue;
            }
            if (!(an instanceof ActionLeaf)) continue;
            m.add(this.buildMenu((ActionLeaf)an));
            separated = false;
        }
    }

    public JMenu buildMenu(String topLevelKey) {
        List<ActionNode> ch = this.rootNode.getChildren();
        for (ActionNode n : ch) {
            ActionFolder af;
            if (!(n instanceof ActionFolder) || !topLevelKey.equals((af = (ActionFolder)n).getKey())) continue;
            JMenu jMenu = new JMenu(af.getDisplayName().localize());
            List<ActionNode> tlch = af.getChildren();
            this.addChildren(jMenu, tlch);
            return jMenu;
        }
        return null;
    }

    public List<JMenuItem> buildMenus() {
        ArrayList<JMenuItem> mis = new ArrayList<JMenuItem>();
        List<ActionNode> ch = this.rootNode.getChildren();
        for (ActionNode n : ch) {
            JMenuItem mi = this.buildMenu(n);
            if (mi == null) continue;
            mis.add(mi);
        }
        return mis;
    }

    public void addToJPopupMenu(JPopupMenu popupMenu) {
        List<JMenuItem> mis = this.buildMenus();
        for (JMenuItem mi : mis) {
            popupMenu.add(mi);
        }
    }

    public JPopupMenu buildJPopupMenu(String label) {
        JPopupMenu pm = new JPopupMenu(label);
        this.addToJPopupMenu(pm);
        return pm;
    }

    public JPopupMenu buildJPopupMenu() {
        JPopupMenu pm = new JPopupMenu();
        this.addToJPopupMenu(pm);
        return pm;
    }
}

