/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.scale;

import ipsk.awt.GridTick;
import ipsk.awt.JScale;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class JDecimalAutoScale
extends JScale<BigDecimal> {
    private static final int DEBUG = 0;
    private static final double DEFAULT_BASE = 10.0;
    private static final BigDecimal[] DEFAULT_DIVIDERS = new BigDecimal[]{new BigDecimal(1), new BigDecimal(2), new BigDecimal(5)};
    private static final double DEFAULT_AXIS_PADDING_FACTOR = 1.2;
    private static final double DEFAULT_NOAXIS_PADDING_FACTOR = 1.1;
    private double horizontalPaddingFactor;
    private double verticalPaddingFactor;
    private Format labelFormat;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private BigDecimal scaleBegin;
    private BigDecimal scaleEnd;
    private BigDecimal bDdelta;
    private double delta;
    private double base;
    private BigDecimal[] dividers;
    private boolean normalizeLabelScales = true;
    private volatile int length = 0;
    private volatile RenderModel renderModel = null;
    private volatile Dimension layoutForSize = null;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public JDecimalAutoScale() {
        this(JScale.Orientation.SOUTH, new BigDecimal(0), new BigDecimal(0));
    }

    public JDecimalAutoScale(JScale.Orientation orientation, BigDecimal from, BigDecimal to) {
        this(orientation, 0, from, to);
    }

    public JDecimalAutoScale(JScale.Orientation orientation, int length, BigDecimal d, BigDecimal e) {
        super(orientation);
        this.setLayout(null);
        this.setLength(length);
        this._rescale(d, e);
        this.base = 10.0;
        this.dividers = DEFAULT_DIVIDERS;
        if (JScale.Orientation.SOUTH.equals((Object)orientation)) {
            this.horizontalPaddingFactor = 1.2;
            this.verticalPaddingFactor = 1.1;
        } else if (JScale.Orientation.WEST.equals((Object)orientation)) {
            this.horizontalPaddingFactor = 1.1;
            this.verticalPaddingFactor = 1.2;
        }
    }

    private void _rescale(BigDecimal d, BigDecimal e) {
        if (this.normalizeLabelScales) {
            this.scaleBegin = d.stripTrailingZeros();
            this.scaleEnd = e.stripTrailingZeros();
        } else {
            this.scaleBegin = d;
            this.scaleEnd = e;
        }
        this.bDdelta = e.subtract(d);
        this.delta = this.bDdelta.doubleValue();
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
        this.rescale();
    }

    private String format(BigDecimal tickValue) {
        return tickValue.toPlainString();
    }

    private String format(Number tickValue) {
        if (this.labelFormat == null) {
            return tickValue.toString();
        }
        return this.labelFormat.format(tickValue);
    }

    protected BigDecimal[] computeExampleTicks() {
        BigDecimal majTickAbsDecimal;
        int minNumExampleTicks = 4;
        double minTick = this.delta / (double)minNumExampleTicks;
        double minTickAbs = Math.abs(minTick);
        double minTickPow = Math.log(minTickAbs) / Math.log(this.base);
        int tickPow = (int)Math.ceil(minTickPow);
        BigDecimal majTickAbs = majTickAbsDecimal = BigDecimal.valueOf(1L, -tickPow);
        for (int i = 0; i < this.dividers.length; ++i) {
            BigDecimal division = majTickAbsDecimal.divide(this.dividers[i]);
            double divisionD = division.doubleValue();
            if (!(divisionD > minTickAbs)) continue;
            majTickAbs = division;
        }
        BigDecimal majTick = this.delta >= 0.0 ? majTickAbs : majTickAbs.multiply(new BigDecimal(-1));
        majTick = majTick.stripTrailingZeros();
        BigDecimal firstTickValue = null;
        BigDecimal nextTickValue = null;
        BigDecimal preLastTickValue = null;
        BigDecimal lastTickValue = null;
        BigDecimal[] samples = new BigDecimal[4];
        if (majTickAbs.signum() > 0) {
            BigDecimal firstTickUnits = this.scaleBegin.divideToIntegralValue(majTickAbs);
            if (this.bDdelta.signum() < 0) {
                firstTickUnits.add(BigDecimal.ONE);
            }
            firstTickValue = firstTickUnits.multiply(majTickAbs).stripTrailingZeros();
            nextTickValue = firstTickValue.add(majTick).stripTrailingZeros();
            preLastTickValue = firstTickValue.add(majTick.multiply(new BigDecimal(minNumExampleTicks - 1))).stripTrailingZeros();
            lastTickValue = firstTickValue.add(majTick.multiply(new BigDecimal(minNumExampleTicks))).stripTrailingZeros();
        }
        samples[0] = firstTickValue;
        samples[1] = nextTickValue;
        samples[2] = preLastTickValue;
        samples[3] = lastTickValue;
        if (this.normalizeLabelScales) {
            int requiredScale = Integer.MIN_VALUE;
            for (BigDecimal s : samples) {
                int sScale;
                if (s == null || (sScale = s.scale()) <= requiredScale) continue;
                requiredScale = sScale;
            }
            BigDecimal[] scaledSamples = new BigDecimal[samples.length];
            for (int i = 0; i < samples.length; ++i) {
                BigDecimal s = samples[i];
                if (s == null) continue;
                scaledSamples[i] = s.setScale(requiredScale);
            }
            samples = scaledSamples;
        }
        return samples;
    }

    private int getMaxScale() {
        double maxScaleD = Math.log(Math.abs(this.delta)) / Math.log(this.base);
        int maxScale = (int)Math.ceil(maxScaleD);
        return maxScale;
    }

    List<BigDecimal> computeTicks(BigDecimal majTickAbs) {
        BigDecimal firstTickValue;
        BigDecimal majTick = this.delta >= 0.0 ? majTickAbs : majTickAbs.multiply(new BigDecimal(-1));
        majTick = majTick.stripTrailingZeros();
        if (majTickAbs.signum() > 0) {
            BigDecimal firstTickUnits = this.scaleBegin.divideToIntegralValue(majTickAbs);
            firstTickUnits.stripTrailingZeros();
            if (this.bDdelta.signum() < 0) {
                firstTickUnits = firstTickUnits.add(BigDecimal.ONE);
            }
            firstTickValue = firstTickUnits.multiply(majTickAbs);
        } else {
            firstTickValue = this.scaleBegin;
        }
        BigDecimal tickValue = firstTickValue = firstTickValue.stripTrailingZeros();
        int d = 1;
        if (this.bDdelta.signum() == -1) {
            d = -1;
        }
        ArrayList<BigDecimal> tickList = new ArrayList<BigDecimal>();
        tickList.add(firstTickValue);
        do {
            tickValue = tickValue.add(majTick);
            tickList.add(tickValue);
        } while (tickValue.subtract(this.scaleEnd).doubleValue() * (double)d < 0.0);
        return tickList;
    }

    public RenderModel computeRenderModel(Dimension size) {
        int length = 0;
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            length = size.width;
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            length = size.height;
        }
        RenderModel rm = null;
        RenderModel goodRenderModel = null;
        List<BigDecimal> tickValueList = null;
        int scale = this.getMaxScale() + 2;
        BigDecimal goodMajTickAbs = null;
        do {
            BigDecimal majTickAbsDecimal = BigDecimal.valueOf(1L, -(scale - 1));
            for (BigDecimal divider : this.dividers) {
                BigDecimal majTickAbs = majTickAbsDecimal.divide(divider);
                rm = this.computeRenderModel(majTickAbs, length);
                if (rm == null) continue;
                Dimension s = rm.getSize();
                if (s.width > size.width || s.height > size.height) continue;
                goodMajTickAbs = majTickAbs;
                goodRenderModel = rm;
            }
            --scale;
        } while (rm != null);
        if (goodMajTickAbs != null) {
            tickValueList = this.computeTicks(goodMajTickAbs);
            goodRenderModel.setTickValueList(tickValueList);
        }
        return goodRenderModel;
    }

    private RenderModel computeRenderModel(BigDecimal majTickAbs, int length) {
        int halfLineLength;
        RenderModel rm = null;
        List<BigDecimal> tickList = this.computeTicks(majTickAbs);
        if (tickList == null) {
            rm = new RenderModel();
            rm.setMajTick(majTickAbs);
            Dimension emptyScaleSize = new Dimension();
            if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
                emptyScaleSize.width = length;
            } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
                emptyScaleSize.height = length;
            }
            rm.setSize(emptyScaleSize);
            return rm;
        }
        Dimension maxLabelSize = new Dimension(0, 0);
        for (BigDecimal tVal : tickList) {
            Dimension labelSize = this.getLabelSize(tVal);
            if (labelSize == null) {
                return null;
            }
            if (labelSize.width > maxLabelSize.width) {
                maxLabelSize.width = labelSize.width;
            }
            if (labelSize.height <= maxLabelSize.height) continue;
            maxLabelSize.height = labelSize.height;
        }
        int majTickPixels = (int)Math.floor((double)length * (majTickAbs.doubleValue() / this.delta));
        if (majTickPixels < 0) {
            majTickPixels = -majTickPixels;
        }
        double paddedLabelWidth = (double)maxLabelSize.width * this.horizontalPaddingFactor;
        double paddedLabelHeight = (double)maxLabelSize.height * this.verticalPaddingFactor;
        int lineLength = 0;
        int minWidth = 0;
        int minHeight = 0;
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            lineLength = maxLabelSize.height;
            halfLineLength = lineLength / 2;
            minHeight = (int)paddedLabelHeight + 2 + halfLineLength;
            minWidth = (int)Math.ceil(paddedLabelWidth);
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            lineLength = maxLabelSize.height;
            halfLineLength = lineLength / 2;
            minWidth = (int)paddedLabelWidth + 2 + halfLineLength;
            minHeight = (int)Math.ceil(paddedLabelHeight);
        }
        Dimension minSize = new Dimension(minWidth, minHeight);
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            boolean fits;
            boolean bl = fits = minSize.width <= majTickPixels;
            if (fits) {
                rm = new RenderModel();
                Dimension minimumSize = new Dimension(length, minSize.height);
                rm.setSize(minimumSize);
            }
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            boolean fits;
            boolean bl = fits = minSize.height <= majTickPixels;
            if (fits) {
                rm = new RenderModel();
                Dimension minimumSize = new Dimension(minSize.width, length);
                rm.setSize(minimumSize);
            }
        }
        if (rm != null) {
            rm.setMajTick(majTickAbs);
            rm.setMaxLabelSize(maxLabelSize);
            rm.setLineLength(lineLength);
        }
        return rm;
    }

    @Override
    protected void paintComponent(Graphics g) {
        block11: {
            int halfLineLength;
            int lineLength;
            Dimension maxLabelSize;
            List<BigDecimal> tickValueList;
            int lineX1;
            int height;
            block12: {
                super.paintComponent(g);
                if (this.isEnabled()) {
                    g.setColor(this.getForeground());
                } else {
                    g.setColor(this.getBackground().darker());
                }
                Rectangle a = g.getClipBounds();
                Dimension size = this.getSize();
                int width = size.width;
                height = size.height;
                if (width == 0 || height == 0) {
                    return;
                }
                lineX1 = 0;
                int lineX2 = 0;
                int lineY1 = 0;
                int lineY2 = 0;
                if (this.renderModel != null) {
                    Dimension rmSize = this.renderModel.getSize();
                    if (!size.equals(rmSize)) {
                        this.renderModel = this.computeRenderModel(size);
                    }
                } else {
                    System.out.println("paint Rendermodel null!");
                }
                if (this.renderModel == null) break block11;
                tickValueList = this.renderModel.getTickValueList();
                maxLabelSize = this.renderModel.getMaxLabelSize();
                lineLength = this.renderModel.getLineLength();
                halfLineLength = lineLength / 2;
                if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
                    lineX1 = a.x;
                    lineX2 = a.x + a.width;
                    lineY2 = lineY1 = height - this.getMinimumSizeFromMaxLabelSize((Dimension)maxLabelSize).height;
                } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
                    lineX2 = lineX1 = this.getMinimumSizeFromMaxLabelSize((Dimension)maxLabelSize).width - 1;
                    lineY1 = a.y;
                    lineY2 = a.y + a.height;
                }
                g.setColor(this.getBackground());
                g.fillRect(lineX1, lineY1, width, height);
                g.setColor(this.getForeground());
                g.drawLine(lineX1, lineY1, lineX2, lineY2);
                if (!JScale.Orientation.SOUTH.equals((Object)this.orientation)) break block12;
                for (BigDecimal tickValue : tickValueList) {
                    int pos = (int)(tickValue.subtract(this.scaleBegin).doubleValue() / this.delta * (double)width);
                    g.drawString(this.format(tickValue), pos + 1, lineY1 + maxLabelSize.height + halfLineLength);
                    g.drawLine(pos, lineY1, pos, lineY1 + lineLength);
                }
                break block11;
            }
            if (!JScale.Orientation.WEST.equals((Object)this.orientation)) break block11;
            for (BigDecimal tickValue : tickValueList) {
                int pos = (int)(tickValue.subtract(this.scaleBegin).doubleValue() / this.delta * (double)height);
                g.drawString(this.format(tickValue), lineX1 - maxLabelSize.width - halfLineLength, pos + maxLabelSize.height);
                g.drawLine(lineX1, pos, lineX1 - lineLength, pos);
            }
        }
    }

    public GridTick<BigDecimal>[] getScaleTicks(int fromPixel, int toPixel) {
        return null;
    }

    public double getVerticalPaddingFactor() {
        return this.verticalPaddingFactor;
    }

    public void setVerticalPaddingFactor(double d) {
        this.verticalPaddingFactor = d;
        this.rescale();
    }

    public double getHorizontalPaddingFactor() {
        return this.horizontalPaddingFactor;
    }

    public void setHorizontalPaddingFactor(double d) {
        this.horizontalPaddingFactor = d;
        this.rescale();
    }

    private Dimension getLabelSize(BigDecimal val) {
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fontMetrics = this.getFontMetrics(f);
            String formattedValue = this.format(val);
            Rectangle2D valBounds = fontMetrics.getStringBounds(formattedValue, this.getGraphics());
            double valWidth = valBounds.getWidth();
            double valHeight = valBounds.getHeight();
            Dimension d = new Dimension();
            d.setSize(valWidth, valHeight);
            return d;
        }
        return null;
    }

    private Dimension getMinimumSizeFromMaxLabelSize(Dimension maxLabelSize) {
        double paddedLabelWidth = (double)maxLabelSize.width * this.horizontalPaddingFactor;
        double paddedLabelHeight = (double)maxLabelSize.height * this.verticalPaddingFactor;
        int minWidth = 0;
        int minHeight = 0;
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            int lineLength = maxLabelSize.height;
            int halfLineLength = lineLength / 2;
            minHeight = (int)paddedLabelHeight + 2 + halfLineLength;
            minWidth = (int)Math.ceil(paddedLabelWidth);
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            int lineLength = maxLabelSize.height;
            int halfLineLength = lineLength / 2;
            minWidth = (int)paddedLabelWidth + 2 + halfLineLength;
            minHeight = (int)Math.ceil(paddedLabelHeight);
        }
        return new Dimension(minWidth, minHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minimumSize = null;
        RenderModel minSizedRenderModel = null;
        int scale = this.getMaxScale();
        RenderModel rm = null;
        do {
            BigDecimal majTickAbsDecimal = BigDecimal.valueOf(1L, -scale);
            BigDecimal majTickAbs = null;
            for (BigDecimal divider : this.dividers) {
                majTickAbs = BigDecimal.ONE.equals(divider) ? majTickAbsDecimal : majTickAbsDecimal.divide(divider);
                rm = this.computeRenderModel(majTickAbs, this.length);
                if (rm == null) continue;
                minSizedRenderModel = rm;
            }
            --scale;
        } while (rm != null);
        minimumSize = minSizedRenderModel != null ? minSizedRenderModel.getSize() : new Dimension();
        return minimumSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Format getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(Format format) {
        this.labelFormat = format;
        this.rescale();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.rescale();
    }

    private void rescale() {
        this._rescale(this.scaleBegin, this.scaleEnd);
        System.out.println("Rescale.");
        this.renderModel = null;
        this.revalidate();
        this.repaint();
    }

    public BigDecimal getScaleBegin() {
        return this.scaleBegin;
    }

    public void setScaleBegin(BigDecimal scaleBegin) {
        this.scaleBegin = scaleBegin;
        this.rescale();
    }

    public BigDecimal getScaleEnd() {
        return this.scaleEnd;
    }

    public void setScaleEnd(BigDecimal scaleEnd) {
        this.scaleEnd = scaleEnd;
        this.rescale();
    }

    @Override
    public JScale.Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public synchronized void setOrientation(JScale.Orientation orientation) {
        if (this.orientation.equals((Object)orientation)) {
            return;
        }
        super.setOrientation(orientation);
        double tmp2 = this.horizontalPaddingFactor;
        this.horizontalPaddingFactor = this.verticalPaddingFactor;
        this.verticalPaddingFactor = tmp2;
        this.rescale();
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        this.renderModel = this.computeRenderModel(size);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                double test = 0.1;
                BigDecimal bd = BigDecimal.valueOf(1L, 1);
                BigDecimal bd2 = bd.multiply(new BigDecimal(7));
                BigDecimal bd3 = BigDecimal.valueOf(-65432L, 10);
                BigDecimal s1 = BigDecimal.valueOf(-10L, 1);
                BigDecimal s2 = s1.stripTrailingZeros();
                for (int i = 0; i < 20; ++i) {
                }
                JDecimalAutoScale jasVer = new JDecimalAutoScale(JScale.Orientation.WEST, BigDecimal.valueOf(10000L, -1), BigDecimal.valueOf(0L, -1));
                jasVer.setLength(800);
                jasVer.setSize(100, 800);
                JFrame testFrameVer = new JFrame(jasVer.getClass().getName() + " Test Vertical");
                testFrameVer.setDefaultCloseOperation(3);
                testFrameVer.getContentPane().add(jasVer);
                testFrameVer.pack();
                testFrameVer.setVisible(true);
            }
        });
    }

    public class RenderModel {
        private Dimension size;
        private Dimension maxLabelSize = new Dimension();
        private int lineLength;
        private BigDecimal majTick;
        private BigDecimal majTickAbs;
        private List<BigDecimal> tickValueList;

        public Dimension getMaxLabelSize() {
            return this.maxLabelSize;
        }

        public void setMaxLabelSize(Dimension maxLabelSize) {
            this.maxLabelSize = maxLabelSize;
        }

        public int getLineLength() {
            return this.lineLength;
        }

        public void setLineLength(int lineLength) {
            this.lineLength = lineLength;
        }

        public List<BigDecimal> getTickValueList() {
            return this.tickValueList;
        }

        public void setTickValueList(List<BigDecimal> tickValueList) {
            this.tickValueList = tickValueList;
        }

        public void setMajTickAbs(BigDecimal majTickAbs) {
            this.majTickAbs = majTickAbs;
        }

        public void setSize(Dimension size) {
            this.size = size;
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setMajTick(BigDecimal majTick) {
            this.majTick = majTick;
        }

        public BigDecimal getMajTick() {
            return this.majTick;
        }

        public BigDecimal getMajTickAbs() {
            return this.majTickAbs;
        }
    }

    public class Size
    extends Dimension2D {
        private double width;
        private double height;

        public Size(double width, double height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public void setSize(double arg0, double arg1) {
            this.width = arg0;
            this.height = arg1;
        }

        @Override
        public Object clone() {
            return new Size(this.width, this.height);
        }
    }
}

