/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.text;

import ipsk.swing.text.EditorKitMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class JStyledDocumentEditor
extends JPanel
implements ActionListener,
DocumentListener {
    private final JTextPane editorPane;
    private JTextPane srcEditorPane;
    private JPanel buttonPanel;
    private EditorKit editorKit;
    private Document srcDoc;
    private Document doc;
    private Color editorForeGroundColor = Color.BLACK;

    public JStyledDocumentEditor() {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 2.0;
        c.weighty = 2.0;
        c.fill = 1;
        this.editorPane = new JTextPane();
        this.editorPane.setPreferredSize(new Dimension(300, 100));
        this.editorPane.setContentType("text/html");
        this.editorPane.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        this.doc = this.editorPane.getDocument();
        EditorKitMenu epEkm = new EditorKitMenu(this.editorPane);
        epEkm.setPopupMenuActiv(true);
        this.editorKit = this.editorPane.getEditorKit();
        this.srcEditorPane = new JTextPane();
        this.srcEditorPane.setPreferredSize(new Dimension(300, 100));
        this.srcEditorPane.setContentType("text/plain");
        EditorKitMenu sepEkm = new EditorKitMenu(this.srcEditorPane);
        sepEkm.setPopupMenuActiv(true);
        this.srcDoc = this.srcEditorPane.getDocument();
        this.add((Component)new JScrollPane(this.editorPane), c);
        ++c.gridx;
        this.add((Component)new JScrollPane(this.srcEditorPane), c);
        c.gridx = 0;
        ++c.gridy;
        this.buttonPanel = new JPanel();
        JToolBar toolBar = new JToolBar();
        JButton boldButton = new JButton("<html><b>B</b></html>");
        JButton italicButton = new JButton("<html><i>i</i></html>");
        for (Action a : this.editorKit.getActions()) {
            String name = (String)a.getValue("Name");
            if (name.equals("font-bold")) {
                boldButton.addActionListener(a);
                continue;
            }
            if (!name.equals("font-italic")) continue;
            italicButton.addActionListener(a);
        }
        JButton wButt = new JButton("Write");
        wButt.addActionListener(this);
        toolBar.add(boldButton);
        toolBar.add(italicButton);
        JButton colorButton = new JButton("Color");
        final JStyledDocumentEditor parent = this;
        toolBar.add(colorButton);
        SpinnerNumberModel model = new SpinnerNumberModel(12, 8, 1000, 10);
        final JSpinner fontSizeSpinner = new JSpinner(model);
        fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer value = (Integer)fontSizeSpinner.getValue();
                StyledEditorKit.FontSizeAction fsAction = new StyledEditorKit.FontSizeAction("font-size-" + value.toString(), value);
                fsAction.actionPerformed(new ActionEvent(JStyledDocumentEditor.this.editorPane, 1001, value.toString()));
            }
        });
        colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c;
                if (JStyledDocumentEditor.this.editorKit instanceof StyledEditorKit && JStyledDocumentEditor.this.doc instanceof StyledDocument) {
                    StyledEditorKit sek = (StyledEditorKit)JStyledDocumentEditor.this.editorKit;
                    StyledDocument sd = (StyledDocument)JStyledDocumentEditor.this.doc;
                    JStyledDocumentEditor.this.editorForeGroundColor = sd.getForeground(sek.getInputAttributes());
                }
                if ((c = JColorChooser.showDialog(parent, "Text color", JStyledDocumentEditor.this.editorForeGroundColor)) == null) {
                    return;
                }
                StyledEditorKit.ForegroundAction fgAction = new StyledEditorKit.ForegroundAction("color", c);
                fgAction.actionPerformed(e);
                JStyledDocumentEditor.this.editorForeGroundColor = c;
            }
        });
        toolBar.add(colorButton);
        toolBar.add(fontSizeSpinner);
        this.buttonPanel.add(toolBar);
        this.buttonPanel.add(wButt);
        this.add((Component)this.buttonPanel, c);
        this.doc.addDocumentListener(this);
        this.srcDoc.addDocumentListener(this);
    }

    public static void main(String[] args) {
        Runnable guiRunnable = new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("Test");
                f.setDefaultCloseOperation(3);
                JStyledDocumentEditor e = new JStyledDocumentEditor();
                f.add(e);
                f.pack();
                f.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(guiRunnable);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Document doc = this.editorPane.getDocument();
        try {
            this.editorKit.write(System.out, doc, 0, doc.getLength());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    private void updateSourcePane(DocumentEvent e) {
        Document d = e.getDocument();
        if (d == this.doc) {
            StringWriter sw = new StringWriter();
            try {
                this.editorKit.write(sw, d, 0, d.getLength());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            String srcText = sw.toString();
            this.srcDoc.removeDocumentListener(this);
            this.srcEditorPane.setText(srcText);
            this.srcDoc.addDocumentListener(this);
        } else if (d == this.srcDoc) {
            try {
                StringReader in = new StringReader(this.srcDoc.getText(0, this.srcDoc.getLength()));
                this.doc.removeDocumentListener(this);
                this.doc.remove(0, this.doc.getLength());
                this.editorKit.read(in, this.doc, 0);
                this.doc.addDocumentListener(this);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private String elementToDescr(Element e) {
        StringBuffer sb = new StringBuffer();
        sb.append(e.getName() + "\n");
        sb.append(e.getClass().getName() + "\n");
        int eCnt = e.getElementCount();
        for (int i = 0; i < eCnt; ++i) {
            sb.append("Child: " + this.elementToDescr(e.getElement(i)) + "\n");
        }
        return sb.toString();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateSourcePane(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        Element[] res;
        this.updateSourcePane(e);
        Document d = e.getDocument();
        for (Element re : res = d.getRootElements()) {
            System.out.println(this.elementToDescr(re));
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateSourcePane(e);
    }
}

