/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.apps.ui;

import ipsk.swing.JDialogPanel;
import ipsk.text.ParserException;
import ipsk.text.Version;
import ipsk.util.apps.UpdateManager;
import ipsk.util.apps.UpdateManagerEvent;
import ipsk.util.apps.UpdateManagerListener;
import ipsk.util.apps.descriptor.ApplicationDescriptor;
import ipsk.util.apps.descriptor.ApplicationVersionDescriptor;
import ipsk.util.apps.descriptor.Change;
import ipsk.util.apps.ui.ApplicationVersionDescriptorUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UpdateDialogUI
extends JDialogPanel
implements UpdateManagerListener {
    private ApplicationDescriptor applicationDescriptor;
    private UpdateManager updateManager;

    public UpdateDialogUI(UpdateManager updateManager) {
        super(JDialogPanel.Options.CANCEL);
        this.updateManager = updateManager;
        this.cancelButton.setText("Close");
        updateManager.addUpdateManagerListener(this);
        this.updateContent();
    }

    private void updateContent() {
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.fill = 2;
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        GridBagConstraints gc2 = new GridBagConstraints();
        gc2.anchor = 17;
        gc2.weightx = 2.0;
        gc2.weighty = 2.0;
        gc2.fill = 1;
        gc2.gridx = 0;
        gc2.gridy = 0;
        gc2.insets = new Insets(1, 1, 1, 1);
        cp.removeAll();
        ApplicationDescriptor ad = this.updateManager.getApplicationDescriptor();
        if (ad == null) {
            JLabel noUpdateLabel = UpdateManager.Status.ERROR.equals((Object)this.updateManager.getStatus()) ? new JLabel("Error: Could not get update information!") : (UpdateManager.Status.LOADING.equals((Object)this.updateManager.getStatus()) ? new JLabel("Loading update information...") : new JLabel("Application descriptor not available!"));
            cp.add((Component)noUpdateLabel, gc);
        } else {
            String overViewMsg;
            String name = ad.getName();
            ApplicationVersionDescriptor appVd = this.updateManager.updateAvailableForPlatform();
            Version currentVersion = this.updateManager.getCurrentVersion();
            JPanel overviewPanel = new JPanel(new GridBagLayout());
            overviewPanel.setBorder(BorderFactory.createTitledBorder(name));
            Change.Priority pr = null;
            if (appVd == null) {
                overViewMsg = "No update available. You are using the latest version (" + currentVersion + ").";
            } else {
                pr = this.updateManager.updatePriority();
                overViewMsg = "Update available: " + appVd.getVersion() + " (current version: " + currentVersion + ").";
                if (Change.Priority.STRONGLY_RECOMMENDED.equals((Object)pr)) {
                    overViewMsg = overViewMsg.concat(" Installation strongly recommended!");
                } else if (Change.Priority.RECOMMENDED.equals((Object)pr)) {
                    overViewMsg = overViewMsg.concat(" Installation recommended.");
                }
            }
            JLabel overViewLabel = new JLabel(overViewMsg);
            overviewPanel.add((Component)overViewLabel, gc2);
            cp.add((Component)overviewPanel, gc);
            ++gc.gridy;
            if (appVd != null) {
                List<ApplicationVersionDescriptor> newerVersions = this.updateManager.newerVersions();
                Collections.reverse(newerVersions);
                StringBuffer chgSb = new StringBuffer();
                for (ApplicationVersionDescriptor nvd : newerVersions) {
                    Version nvv = nvd.getVersion();
                    chgSb.append(nvv.toString());
                    chgSb.append(":\n");
                    List<Change> chgs = nvd.getChanges();
                    for (Change chg : chgs) {
                        chgSb.append('\t');
                        chgSb.append(chg);
                        chgSb.append('\n');
                    }
                }
                ApplicationVersionDescriptorUI appVdUi = new ApplicationVersionDescriptorUI(appVd, this.updateManager.desktopDownloadPossible());
                appVdUi.setActionListener(this);
                appVdUi.setBorder(BorderFactory.createTitledBorder("Latest version"));
                cp.add((Component)appVdUi, gc);
                ++gc.gridy;
                JPanel changesPanel = new JPanel(new BorderLayout());
                changesPanel.setBorder(BorderFactory.createTitledBorder("Changes"));
                JTextArea ta = new JTextArea(chgSb.toString());
                JScrollPane changesScrollPane = new JScrollPane(ta);
                changesScrollPane.setPreferredSize(new Dimension(400, 300));
                changesPanel.add((Component)changesScrollPane, "Center");
                gc.weighty = 20.0;
                gc.fill = 1;
                cp.add((Component)changesPanel, gc);
            }
        }
    }

    public static void main(String[] args) {
        try {
            Version currentVersion = Version.parseString(args[0]);
            URL appDescrUrl = new URL(args[1]);
            final UpdateManager um = new UpdateManager(currentVersion);
            um.addUpdateManagerListener(new UpdateManagerListener(){

                @Override
                public void update(UpdateManagerEvent event) {
                    if (UpdateManager.Status.SUCCESS.equals(event)) {
                        UpdateDialogUI ud = new UpdateDialogUI(um);
                        JOptionPane.showMessageDialog(null, ud, "Updates", 1);
                        System.exit(0);
                    }
                }
            });
            um.startLoadApplicationDescriptor(appDescrUrl);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        return this.applicationDescriptor;
    }

    @Override
    public void update(UpdateManagerEvent event) {
        this.updateContent();
        Container tlAn = this.getTopLevelAncestor();
        if (tlAn != null && tlAn instanceof Window) {
            Window w = (Window)tlAn;
            w.pack();
            Container frameParent = w.getParent();
            if (frameParent != null) {
                w.setLocationRelativeTo(frameParent);
            } else {
                w.setLocationRelativeTo(null);
            }
        }
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae instanceof ApplicationVersionDescriptorUI.DownloadActionEvent) {
            ApplicationVersionDescriptorUI.DownloadActionEvent dae = (ApplicationVersionDescriptorUI.DownloadActionEvent)ae;
            DownloadActionOption dao = new DownloadActionOption(dae.getApplicationVersionDescriptor(), true);
            this.setValue(dao);
            this.disposeDialog();
        } else {
            super.actionPerformed(ae);
        }
    }

    public class DownloadActionOption {
        private ApplicationVersionDescriptor applicationVersionDescriptor;
        private boolean requestApplicationQuit;

        public ApplicationVersionDescriptor getApplicationVersionDescriptor() {
            return this.applicationVersionDescriptor;
        }

        public boolean isRequestApplicationQuit() {
            return this.requestApplicationQuit;
        }

        public DownloadActionOption(ApplicationVersionDescriptor applicationVersionDescriptor, boolean requestApplicationQuit) {
            this.applicationVersionDescriptor = applicationVersionDescriptor;
            this.requestApplicationQuit = requestApplicationQuit;
        }
    }
}

