/*
 * Decompiled with CFR 0.152.
 */
package ips.media.action;

import ips.media.MediaLengthUnit;
import ips.media.MediaView;
import ipsk.swing.action.tree.ActionFolder;
import ipsk.swing.action.tree.ActionGroup;
import ipsk.swing.action.tree.RadioActionGroup;
import ipsk.swing.action.tree.RadioActionLeaf;
import ipsk.text.MediaTimeFormat;
import ipsk.text.TimeFormat;
import ipsk.util.LocalizableMessage;
import java.awt.event.ActionEvent;

public class MediaViewActions {
    private MediaView mediaView;
    private MediaLengthUnitFramesAction mediaLenFramesAction = new MediaLengthUnitFramesAction();
    private MediaLengthUnitTimeAction mediaLenTimeAction = new MediaLengthUnitTimeAction();
    private RadioActionGroup mediaLenUnitGroup = new RadioActionGroup();
    private TimeFormatSecondsMsAction timeFormatSecondsMsAction = new TimeFormatSecondsMsAction();
    private MediaTimeFormatAction mediaTimeAction = new MediaTimeFormatAction();
    private RadioActionGroup timeFormatGroup = new RadioActionGroup();

    public MediaViewActions(MediaView mediaView) {
        this.mediaLenUnitGroup.add(this.mediaLenFramesAction);
        this.mediaLenUnitGroup.add(this.mediaLenTimeAction);
        this.mediaLenFramesAction.setRadioActionGroup(this.mediaLenUnitGroup);
        this.mediaLenTimeAction.setRadioActionGroup(this.mediaLenUnitGroup);
        ActionGroup lengthUnitGroup = new ActionGroup("view.length_unit");
        ActionFolder uaf = new ActionFolder("view.units", new LocalizableMessage("Units"));
        lengthUnitGroup.add(uaf);
        ActionFolder tff = new ActionFolder("view.units.time", new LocalizableMessage("Time"));
        uaf.add(tff);
        this.timeFormatGroup.add(this.timeFormatSecondsMsAction);
        this.timeFormatGroup.add(this.mediaTimeAction);
        this.timeFormatSecondsMsAction.setRadioActionGroup(this.timeFormatGroup);
        this.mediaTimeAction.setRadioActionGroup(this.timeFormatGroup);
        tff.add(this.timeFormatSecondsMsAction);
        tff.add(this.mediaTimeAction);
        this.timeFormatSecondsMsAction.setSelected(true);
        uaf.add(this.mediaLenFramesAction);
        uaf.add(this.mediaLenTimeAction);
        this.setMediaView(mediaView);
    }

    public MediaView getMediaView() {
        return this.mediaView;
    }

    public void setMediaView(MediaView mediaView) {
        this.mediaView = mediaView;
        MediaLengthUnit mlu = mediaView.getMediaLengthUnit();
        if (MediaLengthUnit.TIME.equals((Object)mlu)) {
            this.mediaLenTimeAction.setSelected(true);
        }
    }

    public MediaLengthUnitFramesAction getMediaLenFramesAction() {
        return this.mediaLenFramesAction;
    }

    public MediaLengthUnitTimeAction getMediaLenTimeAction() {
        return this.mediaLenTimeAction;
    }

    public TimeFormatSecondsMsAction getTimeFormatSecondsMsAction() {
        return this.timeFormatSecondsMsAction;
    }

    public MediaTimeFormatAction getMediaTimeAction() {
        return this.mediaTimeAction;
    }

    public class MediaTimeFormatAction
    extends RadioActionLeaf {
        public MediaTimeFormatAction() {
            super(new LocalizableMessage("Mediatime (00:00:00.000)"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MediaViewActions.this.mediaView.setTimeFormat(MediaTimeFormat.MEDIA_TIME_FORMAT);
        }
    }

    public class TimeFormatSecondsMsAction
    extends RadioActionLeaf {
        public TimeFormatSecondsMsAction() {
            super(new LocalizableMessage("Seconds (00.000)"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MediaViewActions.this.mediaView.setTimeFormat(TimeFormat.FIXED_SECONDS_MS_TIME_FORMAT);
        }
    }

    public class MediaLengthUnitTimeAction
    extends RadioActionLeaf {
        public MediaLengthUnitTimeAction() {
            super(new LocalizableMessage("Media length in time"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MediaViewActions.this.mediaView.setMediaLengthUnit(MediaLengthUnit.TIME);
        }
    }

    public class MediaLengthUnitFramesAction
    extends RadioActionLeaf {
        public MediaLengthUnitFramesAction() {
            super(new LocalizableMessage("Media length in frames"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MediaViewActions.this.mediaView.setMediaLengthUnit(MediaLengthUnit.FRAMES);
        }
    }
}

