/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

public class ChannelRouting {
    private int srcChannels = 0;
    private Integer[] assignment;

    public ChannelRouting(Integer[] assignment) {
        this(null, assignment);
    }

    public ChannelRouting(Integer srcChannels, Integer[] assignment) {
        if (srcChannels != null) {
            this.srcChannels = srcChannels;
        }
        this.assignment = assignment;
        if (assignment != null) {
            for (int trgCh = 0; trgCh < assignment.length; ++trgCh) {
                int as = assignment[trgCh];
                if (srcChannels != null) {
                    if (as < srcChannels) continue;
                    throw new IllegalArgumentException("Target channel index " + trgCh + " cannot be assigned to source channel index " + as + ". Index outside source channel count " + srcChannels);
                }
                if (as < this.srcChannels) continue;
                this.srcChannels = as + 1;
            }
        }
    }

    public ChannelRouting(boolean sourceOffset, int channelOffset, int channels) {
        if (sourceOffset) {
            this.srcChannels = channelOffset + channels;
            this.assignment = new Integer[channels];
            for (int trgCh = 0; trgCh < channels; ++trgCh) {
                this.assignment[trgCh] = channelOffset + trgCh;
            }
        } else {
            this.srcChannels = channels;
            int trgChannels = channelOffset + channels;
            this.assignment = new Integer[trgChannels];
            for (int trgCh = 0; trgCh < trgChannels; ++trgCh) {
                this.assignment[trgCh] = trgCh < channelOffset ? null : Integer.valueOf(trgCh - channelOffset);
            }
        }
    }

    public int getTrgChannels() {
        if (this.assignment != null) {
            return this.assignment.length;
        }
        return this.srcChannels;
    }

    public int getSrcChannels() {
        return this.srcChannels;
    }

    public Integer[] getAssignment() {
        return this.assignment;
    }
}

