/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.text.ParserException;
import java.nio.file.Path;
import java.util.Locale;

public class MIMEType {
    public static final String TYPE_AUDIO = "audio";
    public static MIMEType TEXT_XML = new MIMEType("text", "xml", "xml");
    public static MIMEType APPLICATION_XML = new MIMEType("application", "xml", "xml");
    public static MIMEType APPLICATION_JSON = new MIMEType("application", "json", "json");
    public static MIMEType IMAGE_JPEG = new MIMEType("image", "jpg", "jpg");
    public static MIMEType IMAGE_PNG = new MIMEType("image", "png", "png");
    public static MIMEType IMAGE_GIF = new MIMEType("image", "gif", "gif");
    public static MIMEType IMAGE_TIFF = new MIMEType("image", "tiff", "tiff");
    public static MIMEType AUDIO_WAVE = new MIMEType("audio", "wav", "wav");
    public static MIMEType AUDIO_AIFF = new MIMEType("audio", "aiff", "aif");
    private static MIMEType[] KNOWN_TYPES = new MIMEType[]{TEXT_XML, APPLICATION_XML, APPLICATION_JSON, IMAGE_JPEG, IMAGE_PNG, AUDIO_WAVE};
    private String type;
    private String subType;
    static String WILDCARD_TYPE = "*";
    private String fileExtension = null;

    public String getFileExtension() {
        return this.fileExtension;
    }

    public MIMEType(String type, String subType, String fileExtension) {
        if (type == null) {
            throw new NullPointerException("Type cannot be null!");
        }
        this.type = type;
        this.subType = subType;
        this.fileExtension = fileExtension;
    }

    private static MIMEType knownType(String type, String subType) {
        for (MIMEType knownType : KNOWN_TYPES) {
            if (!knownType.getType().equals(type) || !knownType.getSubType().equals(subType)) continue;
            return knownType;
        }
        return null;
    }

    public static MIMEType knownMimeTypeByFilename(String filename) {
        for (MIMEType kmt : KNOWN_TYPES) {
            if (!filename.toLowerCase(Locale.US).matches(".*[.]" + kmt.getFileExtension() + "$")) continue;
            return kmt;
        }
        return null;
    }

    public static MIMEType knownMimeTypeByPath(Path filePath) {
        Path fnamePath = filePath.getFileName();
        if (fnamePath != null) {
            return MIMEType.knownMimeTypeByFilename(fnamePath.toString());
        }
        return null;
    }

    public static MIMEType parse(String mimeTypeString) throws ParserException {
        MIMEType knownType;
        String[] splitStr = mimeTypeString.trim().split("\\s*/\\s*");
        if (splitStr == null) {
            throw new ParserException("Could not parse MIME type: " + mimeTypeString);
        }
        int splitStrCmps = splitStr.length;
        if (splitStrCmps < 1 || splitStrCmps > 2) {
            throw new ParserException("Could not parse MIME type: " + mimeTypeString);
        }
        String type = splitStr[0];
        String subType = null;
        if (splitStrCmps > 1) {
            subType = splitStr[1];
        }
        return (knownType = MIMEType.knownType(type, subType)) != null ? knownType : new MIMEType(type, subType, null);
    }

    private boolean matchesType(String type, String otherType) {
        return WILDCARD_TYPE.equals(type) || WILDCARD_TYPE.equals(otherType) || type.equals(otherType);
    }

    private boolean matchesSubType(String subType, String otherSubType) {
        return subType == null || otherSubType == null || this.matchesType(subType, otherSubType);
    }

    public boolean matches(MIMEType otherMimeType) {
        return this.matchesType(this.type, otherMimeType.getType()) && this.matchesSubType(this.subType, otherMimeType.getSubType());
    }

    public boolean equals(Object other) {
        if (other instanceof MIMEType) {
            MIMEType otherMimeType = (MIMEType)other;
            boolean typeEq = this.type.equals(otherMimeType.getType());
            if (!typeEq) {
                return false;
            }
            String otherSubType = otherMimeType.getSubType();
            if (this.subType == null) {
                return otherSubType == null;
            }
            return this.subType.equals(otherSubType);
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public String toString() {
        String s = this.type;
        if (this.subType != null) {
            s = s.concat("/" + this.subType);
        }
        return s;
    }

    private int precedenceValue(MIMEType mime) {
        String subType;
        int val = 0;
        String type = mime.getType();
        if (!WILDCARD_TYPE.equals(type)) {
            val += 8;
        }
        if ((subType = mime.getSubType()) != null) {
            val += 2;
            if (!WILDCARD_TYPE.equals(subType)) {
                val += 4;
            }
        }
        return val;
    }

    public int precedenceCompare(MIMEType o) {
        return this.precedenceValue(this) - this.precedenceValue(o);
    }
}

