//    IPS Java Utils
// 	  (c) Copyright 2018
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.util.apps.ui;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

import ipsk.swing.JDialogPanel;
import ipsk.util.apps.UpdateManagerConfig;
import ipsk.util.apps.descriptor.Change;
import ipsk.util.apps.descriptor.Change.Priority;

/**
 * @author klausj
 *
 */
public class JUpdateManagerConfigDialog extends JDialogPanel {

    private UpdateManagerConfig config;
    
  
    public UpdateManagerConfig getConfig() {
        return config;
    }

    public void setConfig(UpdateManagerConfig config) {
        this.config = config;
        checkOnStartup.setSelected(config.isCheckOnStartup());
        notificationPriorityBox.setSelectedItem(config.getInformOnUpdatePriority());
        
    }
    
    public void apply(){
        if(this.config!=null){
            this.config.setCheckOnStartup(checkOnStartup.isSelected());
            this.config.setInformOnUpdatePriority((Priority) notificationPriorityBox.getSelectedItem());
        }
    }

    private JCheckBox checkOnStartup;
    
    private JComboBox<Change.Priority> notificationPriorityBox;
    
    /**
     * 
     */
    public JUpdateManagerConfigDialog(String applicationName) {
        super(JDialogPanel.Options.OK);
        ResourceBundle rb=ResourceBundle.getBundle("ipsk.util.Messages");
        setFrameTitle(rb.getString("ipsk.util.apps.updatemanager.configuration.title"));
        config=new UpdateManagerConfig();
        Container co=getContentPane();
        co.setLayout(new GridBagLayout());
       
        GridBagConstraints lc=new GridBagConstraints();
        lc.insets = new Insets(2, 2, 2, 2);
        lc.gridx=0;
        lc.gridy=0;
        lc.fill=GridBagConstraints.HORIZONTAL;
        JLabel checkOnStartUpLabel=new JLabel("Check for updates on startup:");
        
        co.add(checkOnStartUpLabel,lc);
        checkOnStartup=new JCheckBox();
        
        lc.gridx++;
        co.add(checkOnStartup,lc);
       
        lc.gridy++;
        lc.gridx=0;
        co.add(new JLabel("Notification priority level:"),lc);
        notificationPriorityBox=new JComboBox<Change.Priority>(Change.Priority.values());
        lc.gridx++;
        co.add(notificationPriorityBox,lc);
        setConfig(config);
    }
    
}
