/*
 * Decompiled with CFR 0.152.
 */
package ips.dsp;

import ipsk.math.Complex;
import ipsk.math.DFT;
import ipsk.math.HammingWindow;

public class FIRFilterBuilder {
    public static double[] buildCoefficientsFromImpulsResponse(Complex[] impulseResponse) {
        int i;
        Complex[] symImpulseResponse = new Complex[impulseResponse.length * 2];
        for (int i2 = 0; i2 < impulseResponse.length; ++i2) {
            symImpulseResponse[i2] = impulseResponse[i2];
            symImpulseResponse[impulseResponse.length + i2] = impulseResponse[impulseResponse.length - 1 - i2];
        }
        Complex[] coeffComplex = DFT.processInvers(symImpulseResponse);
        double[] coeff = new double[coeffComplex.length];
        for (i = 0; i < coeffComplex.length / 2; ++i) {
            double c;
            coeff[i] = c = coeffComplex[coeffComplex.length / 2 + i].real;
        }
        for (i = 0; i < coeffComplex.length / 2; ++i) {
            double c2;
            coeff[coeffComplex.length / 2 + i] = c2 = coeffComplex[i].real;
        }
        HammingWindow hw = new HammingWindow(coeff.length);
        for (int i3 = 0; i3 < coeff.length; ++i3) {
            double scale = hw.getScale(i3);
            coeff[i3] = coeff[i3] * scale;
        }
        return coeff;
    }
}

