/*
 * Decompiled with CFR 0.152.
 */
package ipsk.beans;

import ipsk.beans.DOMCodecException;
import ipsk.beans.DOMElementConvertible;
import ipsk.beans.LinkID;
import ipsk.beans.dom.DOMAttributes;
import ipsk.beans.dom.DOMCollectionElement;
import ipsk.beans.dom.DOMElement;
import ipsk.beans.dom.DOMElements;
import ipsk.beans.dom.DOMRoot;
import ipsk.beans.dom.DOMTextNodePropertyName;
import ipsk.beans.dom.RemoveIfDefault;
import ipsk.beans.dom.Temporal;
import ipsk.beans.test.Child1;
import ipsk.beans.test.Root;
import ipsk.beans.test.SuperRoot;
import ipsk.text.ParserException;
import ipsk.text.RFC3339DateTimeFormat;
import ipsk.text.StringObjectConverter;
import ipsk.xml.DOMAttribute;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMCodec {
    public static final String attributePrefix = "attribute";
    private boolean elementNameUpperCase = true;
    private Package elementsPackage;
    private DocumentBuilder db = null;

    public DOMCodec() throws DOMCodecException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new DOMCodecException(e);
        }
    }

    public DOMCodec(Package elementsPackage) throws DOMCodecException {
        this();
        this.setElementsPackage(elementsPackage);
    }

    public DOMCodec(Package elementsPackage, boolean elementNameUpperCase) throws DOMCodecException {
        this(elementsPackage);
        this.elementNameUpperCase = elementNameUpperCase;
    }

    public void setElementsPackage(Package elementsPackage) {
        this.elementsPackage = elementsPackage;
    }

    public Object readDocument(Document document) throws DOMCodecException {
        Element rootElement = document.getDocumentElement();
        return this.createObject(rootElement);
    }

    private PropertyDescriptor getPropertyDescriptorByName(PropertyDescriptor[] descriptors, String name) {
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getName().equals(name)) continue;
            return descriptors[i];
        }
        return null;
    }

    private PropertyDescriptor getPropertyDescriptorByArrayType(PropertyDescriptor[] descriptors, String componentTypeName) {
        for (PropertyDescriptor pd : descriptors) {
            Class<?> pdCompType;
            Class<?> pdType = pd.getPropertyType();
            if (!pdType.isArray() || !(pdCompType = pdType.getComponentType()).getSimpleName().equals(componentTypeName)) continue;
            return pd;
        }
        return null;
    }

    private Object createObject(Element e) throws DOMCodecException {
        return this.createObject(e, null);
    }

    private Object createObject(Element e, Class<?> c) throws DOMCodecException {
        BeanInfo bi = null;
        String className = null;
        if (c != null) {
            className = c.getName();
        }
        String elementClassname = new String(e.getTagName());
        if (!this.elementNameUpperCase) {
            elementClassname = new String(elementClassname.substring(0, 1).toUpperCase(Locale.ENGLISH) + elementClassname.substring(1));
        }
        if (className == null) {
            className = this.elementsPackage.getName();
            className = className.concat("." + elementClassname);
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                throw new DOMCodecException(e1);
            }
        }
        Object bean = null;
        if (c.isPrimitive() || Number.class.isAssignableFrom(c)) {
            NodeList childs = e.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                short nodeType = node.getNodeType();
                if (nodeType != 3) continue;
                try {
                    bean = StringObjectConverter.stringToObject(node.getNodeValue(), c);
                    continue;
                }
                catch (ParserException e1) {
                    throw new DOMCodecException(e1);
                }
            }
        } else if (c.isEnum()) {
            ?[] enumConstants;
            String enumString = null;
            NodeList childs = e.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                ?[] node = childs.item(i);
                int nodeType = node.getNodeType();
                if (nodeType != 3) continue;
                enumString = node.getNodeValue();
            }
            for (Object enumConstant : enumConstants = c.getEnumConstants()) {
                Enum eConst;
                if (!(enumConstant instanceof Enum) || !(eConst = (Enum)enumConstant).toString().equals(enumString)) continue;
                bean = eConst;
                break;
            }
        } else if (UUID.class.equals(c)) {
            String uuidString = null;
            NodeList childs = e.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                short nodeType = node.getNodeType();
                if (nodeType != 3) continue;
                uuidString = node.getNodeValue();
            }
            bean = UUID.fromString(uuidString);
        } else {
            try {
                bean = c.newInstance();
            }
            catch (Exception ex) {
                throw new DOMCodecException(ex);
            }
            if (c.equals(String.class)) {
                NodeList childs = e.getChildNodes();
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node node = childs.item(i);
                    short nodeType = node.getNodeType();
                    if (nodeType != 3) continue;
                    bean = node.getNodeValue();
                }
            } else {
                NamedNodeMap attrMap = e.getAttributes();
                if (bean instanceof ipsk.xml.DOMElement) {
                    int len = attrMap.getLength();
                    DOMAttribute[] attributes = new DOMAttribute[len];
                    for (int i = 0; i < len; ++i) {
                        Attr attrNode = (Attr)attrMap.item(i);
                        attributes[i] = new DOMAttribute(attrNode.getName(), attrNode.getValue());
                    }
                    ((ipsk.xml.DOMElement)bean).setAttributes(attributes);
                    NodeList i = e.getChildNodes();
                } else {
                    PropertyDescriptor pd;
                    try {
                        bi = Introspector.getBeanInfo(c);
                    }
                    catch (IntrospectionException e1) {
                        throw new DOMCodecException(e1);
                    }
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                    if (attrMap != null) {
                        int len = attrMap.getLength();
                        DOMAttributes domAttributesAnnot = c.getAnnotation(DOMAttributes.class);
                        String[] domAttributeNames = null;
                        if (domAttributesAnnot != null) {
                            domAttributeNames = domAttributesAnnot.value();
                        }
                        for (int i = 0; i < len; ++i) {
                            Attr attrNode = (Attr)attrMap.item(i);
                            String attrName = attrNode.getName();
                            String propName = null;
                            if (domAttributeNames != null) {
                                propName = attrName;
                            } else {
                                propName = new String(attributePrefix + attrName.substring(0, 1).toUpperCase(Locale.ENGLISH));
                                propName = propName.concat(attrName.substring(1));
                            }
                            PropertyDescriptor pd2 = this.getPropertyDescriptorByName(pds, propName);
                            if (pd2 == null) {
                                throw new DOMCodecException("Cannot associate attribute '" + propName + "'");
                            }
                            Class<?> propertyType = pd2.getPropertyType();
                            Method setMethod = pd2.getWriteMethod();
                            try {
                                Object attributeValue = null;
                                if (propertyType.isEnum()) {
                                    ?[] enumConstants;
                                    for (Object enumConstant : enumConstants = propertyType.getEnumConstants()) {
                                        if (!(enumConstant instanceof Enum)) continue;
                                        Enum eConst = (Enum)enumConstant;
                                        if (!attrNode.getValue().equals(eConst.toString())) continue;
                                        attributeValue = eConst;
                                        break;
                                    }
                                } else if (Date.class.isAssignableFrom(propertyType)) {
                                    RFC3339DateTimeFormat dateTimeFormat = new RFC3339DateTimeFormat();
                                    attributeValue = dateTimeFormat.parseObject(attrNode.getValue());
                                } else {
                                    attributeValue = StringObjectConverter.stringToObject(attrNode.getValue(), propertyType);
                                }
                                setMethod.invoke(bean, attributeValue);
                                continue;
                            }
                            catch (Exception ex) {
                                throw new DOMCodecException("Cannot associate attribute '" + propName + "'", ex);
                            }
                        }
                    }
                    String textNodePropertyName = null;
                    DOMTextNodePropertyName textNodePropAnno = c.getAnnotation(DOMTextNodePropertyName.class);
                    if (textNodePropAnno != null && (pd = this.getPropertyDescriptorByName(pds, textNodePropertyName = textNodePropAnno.value())) != null) {
                        String text = null;
                        Method setMethod = pd.getWriteMethod();
                        NodeList nl = e.getChildNodes();
                        for (int i = 0; i < nl.getLength(); ++i) {
                            Node n = nl.item(i);
                            if (n.getNodeType() != 3) continue;
                            String nodeText = n.getTextContent();
                            text = text == null ? new String(nodeText) : text.concat(nodeText);
                        }
                        try {
                            setMethod.invoke(bean, text);
                        }
                        catch (Exception e1) {
                            throw new DOMCodecException("Cannot set '" + textNodePropertyName + "' text node property!", e1);
                        }
                    }
                    NodeList childs = e.getChildNodes();
                    HashSet<String> arrayMethodsSet = new HashSet<String>();
                    for (int i = 0; i < childs.getLength(); ++i) {
                        String strValue;
                        NodeList propertyValueNodes;
                        Node collElementNode;
                        int j;
                        NodeList collNodelist;
                        Collection<Object> coll;
                        Object newParamElement;
                        Type setType;
                        Class setClass;
                        Type rt;
                        Node node = childs.item(i);
                        short nodeType = node.getNodeType();
                        if (nodeType != 1) continue;
                        Element childElement = (Element)node;
                        String tagName = childElement.getTagName();
                        String propName = tagName.substring(0, 1).toLowerCase(Locale.ENGLISH);
                        propName = propName.concat(tagName.substring(1));
                        PropertyDescriptor pd3 = this.getPropertyDescriptorByName(pds, propName = propName.replace('_', '.'));
                        if (pd3 == null && (pd3 = this.getPropertyDescriptorByArrayType(pds, tagName)) == null) {
                            throw new DOMCodecException("Cannot associate element '" + propName + "'");
                        }
                        Class<?> propertyType = pd3.getPropertyType();
                        HashMap param = null;
                        Method setMethod = pd3.getWriteMethod();
                        if (propertyType.isArray()) {
                            Class<?> arrType = propertyType.getComponentType();
                            Method getMethod = pd3.getReadMethod();
                            if (arrayMethodsSet.contains(propName)) {
                                try {
                                    param = getMethod.invoke(bean, new Object[0]);
                                }
                                catch (Exception e2) {
                                    throw new DOMCodecException(e2);
                                }
                            }
                            if (param == null) {
                                param = Array.newInstance(arrType, 0);
                                try {
                                    setMethod.invoke(bean, param);
                                }
                                catch (Exception e3) {
                                    throw new DOMCodecException(e3);
                                }
                            }
                            int arrLen = Array.getLength(param) + 1;
                            HashSet oldParam = param;
                            param = Array.newInstance(arrType, arrLen);
                            for (int a = 0; a < arrLen - 1; ++a) {
                                Array.set(param, a, Array.get(oldParam, a));
                            }
                            Object newParamElement2 = null;
                            newParamElement2 = this.createObject(childElement, arrType);
                            Array.set(param, arrLen - 1, newParamElement2);
                            arrayMethodsSet.add(propName);
                        } else if (List.class.isAssignableFrom(propertyType)) {
                            Method getMethod = pd3.getReadMethod();
                            String collElementName = propName;
                            DOMCollectionElement domCollectionElementAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                            if (domCollectionElementAnno != null) {
                                collElementName = domCollectionElementAnno.collectionElementName();
                            }
                            rt = getMethod.getGenericReturnType();
                            setClass = null;
                            if (rt instanceof ParameterizedType) {
                                Type[] listTypes = ((ParameterizedType)rt).getActualTypeArguments();
                                if (listTypes.length != 1) {
                                    throw new DOMCodecException("List with more than one parameterized types!");
                                }
                                setType = listTypes[0];
                                if (setType != null && setType instanceof Class) {
                                    setClass = (Class)setType;
                                }
                            } else {
                                throw new DOMCodecException("Cannot convert unparametrized collection types: " + propName + " !");
                            }
                            try {
                                param = getMethod.invoke(bean, new Object[0]);
                            }
                            catch (Exception e2) {
                                throw new DOMCodecException(e2);
                            }
                            if (param == null) {
                                param = new HashSet();
                                try {
                                    setMethod.invoke(bean, param);
                                }
                                catch (Exception e3) {
                                    throw new DOMCodecException(e3);
                                }
                            }
                            newParamElement = null;
                            coll = (List)((Object)param);
                            if (domCollectionElementAnno == null) {
                                newParamElement = this.createObject(childElement, setClass);
                                coll.add(newParamElement);
                            } else {
                                collNodelist = childElement.getElementsByTagName(collElementName);
                                int collElementsCount = collNodelist.getLength();
                                for (j = 0; j < collElementsCount; ++j) {
                                    collElementNode = collNodelist.item(j);
                                    if (!(collElementNode instanceof Element)) continue;
                                    Element collElementElement = (Element)collElementNode;
                                    newParamElement = this.createObject(collElementElement, setClass);
                                    coll.add(newParamElement);
                                }
                            }
                        } else if (Set.class.isAssignableFrom(propertyType)) {
                            Method getMethod = pd3.getReadMethod();
                            String collElementName = propName;
                            DOMCollectionElement domCollectionElementAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                            if (domCollectionElementAnno != null) {
                                collElementName = domCollectionElementAnno.collectionElementName();
                            }
                            rt = getMethod.getGenericReturnType();
                            setClass = null;
                            if (rt instanceof ParameterizedType) {
                                Type[] setTypes = ((ParameterizedType)rt).getActualTypeArguments();
                                if (setTypes.length != 1) {
                                    throw new DOMCodecException("Set with more than one parameterized types!");
                                }
                                setType = setTypes[0];
                                if (setType != null && setType instanceof Class) {
                                    setClass = (Class)setType;
                                }
                            } else {
                                throw new DOMCodecException("Cannot convert unparametrized collection types: " + propName + " !");
                            }
                            try {
                                param = getMethod.invoke(bean, new Object[0]);
                            }
                            catch (Exception e2) {
                                throw new DOMCodecException(e2);
                            }
                            if (param == null) {
                                param = new HashSet();
                                try {
                                    setMethod.invoke(bean, param);
                                }
                                catch (Exception e3) {
                                    throw new DOMCodecException(e3);
                                }
                            }
                            newParamElement = null;
                            coll = (Set)((Object)param);
                            if (domCollectionElementAnno == null) {
                                newParamElement = this.createObject(childElement, setClass);
                                coll.add(newParamElement);
                            } else {
                                collNodelist = childElement.getElementsByTagName(collElementName);
                                int collElementsCount = collNodelist.getLength();
                                for (j = 0; j < collElementsCount; ++j) {
                                    collElementNode = collNodelist.item(j);
                                    if (!(collElementNode instanceof Element)) continue;
                                    Element collElementElement = (Element)collElementNode;
                                    newParamElement = this.createObject(collElementElement, setClass);
                                    coll.add(newParamElement);
                                }
                            }
                        } else if (Map.class.isAssignableFrom(propertyType)) {
                            Method getMethod = pd3.getReadMethod();
                            String collElementName = propName;
                            DOMCollectionElement domCollectionElementAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                            if (domCollectionElementAnno != null) {
                                collElementName = domCollectionElementAnno.collectionElementName();
                            }
                            rt = getMethod.getGenericReturnType();
                            Class mapKeyClass = null;
                            Class mapValueClass = null;
                            if (rt instanceof ParameterizedType) {
                                Type[] mapTypes = ((ParameterizedType)rt).getActualTypeArguments();
                                if (mapTypes.length != 2) {
                                    throw new DOMCodecException("Map with more than two parameterized types!");
                                }
                                Type mapKeyType = mapTypes[0];
                                Type mapValType = mapTypes[1];
                                if (mapKeyType != null && mapKeyType instanceof Class && mapValType != null && mapValType instanceof Class) {
                                    mapKeyClass = (Class)mapKeyType;
                                    mapValueClass = (Class)mapValType;
                                }
                            } else {
                                throw new DOMCodecException("Cannot convert unparametrized collection types: " + propName + " !");
                            }
                            try {
                                param = getMethod.invoke(bean, new Object[0]);
                            }
                            catch (Exception e2) {
                                throw new DOMCodecException(e2);
                            }
                            if (param == null) {
                                param = new HashMap();
                                try {
                                    setMethod.invoke(bean, param);
                                }
                                catch (Exception e3) {
                                    throw new DOMCodecException(e3);
                                }
                            }
                            Object newParamElement3 = null;
                            Map map = param;
                            NodeList mapNodelist = childElement.getChildNodes();
                            int mapElementsCount = mapNodelist.getLength();
                            Object currentKey = null;
                            for (int j2 = 0; j2 < mapElementsCount; ++j2) {
                                NodeList entryValList;
                                int entryValCount;
                                Element mapElementElement;
                                String nName;
                                Node mapElementNode = mapNodelist.item(j2);
                                if (!(mapElementNode instanceof Element) || !"entry".equals(nName = (mapElementElement = (Element)mapElementNode).getNodeName())) continue;
                                NodeList entryKeyList = mapElementElement.getElementsByTagName("key");
                                int entryKeyCount = entryKeyList.getLength();
                                if (entryKeyCount > 1) {
                                    throw new DOMCodecException("Ambigious keys for map entry!");
                                }
                                Object key = null;
                                if (entryKeyCount == 1) {
                                    Node keyNode = entryKeyList.item(0);
                                    String nv = keyNode.getTextContent();
                                    try {
                                        key = StringObjectConverter.stringToObject(nv, mapKeyClass);
                                    }
                                    catch (ParserException e1) {
                                        throw new DOMCodecException("Cannot convert map key " + nv + " to object!");
                                    }
                                }
                                if ((entryValCount = (entryValList = mapElementElement.getElementsByTagName("value")).getLength()) > 1) {
                                    throw new DOMCodecException("Ambigious values for map entry!");
                                }
                                Object val = null;
                                if (entryValCount == 1) {
                                    Node valNode = entryValList.item(0);
                                    String valText = valNode.getTextContent();
                                    try {
                                        val = StringObjectConverter.stringToObject(valText, mapValueClass);
                                    }
                                    catch (ParserException e1) {
                                        throw new DOMCodecException("Cannot convert map value " + valText + " to object!");
                                    }
                                }
                                map.put(key, val);
                            }
                        } else if (propertyType.isPrimitive() || propertyType.equals(Boolean.class)) {
                            propertyValueNodes = childElement.getChildNodes();
                            for (int k = 0; k < propertyValueNodes.getLength(); ++k) {
                                Node propValueNode = propertyValueNodes.item(k);
                                if (propValueNode.getNodeType() != 3) continue;
                                strValue = propValueNode.getNodeValue();
                                try {
                                    param = StringObjectConverter.stringToObject(strValue, propertyType);
                                    break;
                                }
                                catch (ParserException e1) {
                                    throw new DOMCodecException(e1);
                                }
                            }
                        } else if (propertyType.equals(String.class)) {
                            if (propName.equals(textNodePropertyName)) {
                                param = childElement.getTextContent();
                            } else {
                                propertyValueNodes = childElement.getChildNodes();
                                for (int k = 0; k < propertyValueNodes.getLength(); ++k) {
                                    Node propValueNode = propertyValueNodes.item(k);
                                    if (propValueNode.getNodeType() != 3) continue;
                                    strValue = propValueNode.getNodeValue();
                                    try {
                                        param = StringObjectConverter.stringToObject(strValue, propertyType);
                                        break;
                                    }
                                    catch (ParserException e1) {
                                        throw new DOMCodecException(e1);
                                    }
                                }
                            }
                        } else if (!propertyType.isPrimitive()) {
                            param = this.createObject(childElement, propertyType);
                        }
                        try {
                            setMethod.invoke(bean, param);
                            continue;
                        }
                        catch (Exception ex) {
                            throw new DOMCodecException(ex);
                        }
                    }
                }
            }
        }
        return bean;
    }

    public Object copy(Object bean) throws DOMCodecException {
        return this.copy(bean, new IdentityHashMap<Object, Object>());
    }

    public Object copy(Object bean, IdentityHashMap<Object, Object> copiedObjects) throws DOMCodecException {
        if (copiedObjects != null && copiedObjects.containsKey(bean)) {
            Object copiedObj = copiedObjects.get(bean);
            return copiedObj;
        }
        AbstractCollection beanCopy = null;
        BeanInfo bi = null;
        Class<?> c = bean.getClass();
        if (c.isArray()) {
            try {
                int length = Array.getLength(bean);
                Class<?> compType = c.getComponentType();
                beanCopy = Array.newInstance(c.getComponentType(), length);
                copiedObjects.put(bean, beanCopy);
                for (int i = 0; i < length; ++i) {
                    Object val = Array.get(bean, i);
                    if (compType.equals(String.class)) {
                        Array.set(beanCopy, i, new String((String)val));
                        continue;
                    }
                    Array.set(beanCopy, i, this.copy(val, copiedObjects));
                }
                return beanCopy;
            }
            catch (Exception e) {
                throw new DOMCodecException(e);
            }
        }
        if (Collection.class.isAssignableFrom(c)) {
            try {
                Collection beanColl = (Collection)bean;
                Class<?> collClass = beanColl.getClass();
                AbstractCollection copyColl = null;
                try {
                    copyColl = (ArrayList)collClass.newInstance();
                }
                catch (InstantiationException ie) {
                    if (bean instanceof List) {
                        copyColl = new ArrayList();
                    }
                    if (bean instanceof Set) {
                        copyColl = new HashSet();
                    }
                    throw new DOMCodecException(ie);
                }
                copiedObjects.put(bean, copyColl);
                for (Object co : beanColl) {
                    Object coCopy = this.copy(co, copiedObjects);
                    copyColl.add(coCopy);
                }
                beanCopy = copyColl;
                return beanCopy;
            }
            catch (Exception e) {
                throw new DOMCodecException(e);
            }
        }
        if (c.isEnum()) {
            beanCopy = bean;
        } else if (Number.class.isAssignableFrom(c)) {
            beanCopy = bean;
        } else if (UUID.class.equals(c)) {
            beanCopy = bean;
        } else {
            try {
                beanCopy = c.newInstance();
                copiedObjects.put(bean, beanCopy);
            }
            catch (Exception e) {
                throw new DOMCodecException(e);
            }
        }
        try {
            bi = Introspector.getBeanInfo(bean.getClass());
        }
        catch (Exception ex) {
            throw new DOMCodecException(ex);
        }
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            Class<?> pClass = pd.getPropertyType();
            Method getMethod = pd.getReadMethod();
            Method setMethod = pd.getWriteMethod();
            Object child = null;
            if (getMethod == null) {
                throw new DOMCodecException("DOM codec copy error: Property \"" + pd.getName() + "\" of class " + c.getCanonicalName() + " has no getter method !");
            }
            try {
                Object childCopy;
                child = getMethod.invoke(bean, new Object[0]);
                if (child == null || setMethod == null) continue;
                if (pClass.isArray()) {
                    childCopy = this.copy(child, copiedObjects);
                    setMethod.invoke((Object)beanCopy, childCopy);
                    continue;
                }
                if (String.class.equals(pClass)) {
                    setMethod.invoke((Object)beanCopy, new String((String)child));
                    continue;
                }
                if (pClass.isPrimitive()) {
                    setMethod.invoke((Object)beanCopy, child);
                    continue;
                }
                if (Boolean.class.equals(pClass)) {
                    setMethod.invoke((Object)beanCopy, new Boolean((Boolean)child));
                    continue;
                }
                if (Byte.class.equals(pClass)) {
                    setMethod.invoke((Object)beanCopy, new Byte((Byte)child));
                    continue;
                }
                if (Short.class.equals(pClass)) {
                    setMethod.invoke((Object)beanCopy, new Short((Short)child));
                    continue;
                }
                if (Integer.class.equals(pClass)) {
                    setMethod.invoke((Object)beanCopy, new Integer((Integer)child));
                    continue;
                }
                if (Long.class.equals(pClass)) {
                    setMethod.invoke((Object)beanCopy, new Long((Long)child));
                    continue;
                }
                if (Float.class.equals(pClass)) {
                    setMethod.invoke((Object)beanCopy, new Float(((Float)child).floatValue()));
                    continue;
                }
                if (Double.class.equals(pClass)) {
                    setMethod.invoke((Object)beanCopy, new Double((Double)child));
                    continue;
                }
                if (URL.class.equals(pClass)) {
                    setMethod.invoke((Object)beanCopy, new URL(((URL)child).toExternalForm()));
                    continue;
                }
                if (URI.class.equals(pClass)) {
                    setMethod.invoke((Object)beanCopy, new URI(((URI)child).toString()));
                    continue;
                }
                if (Class.class.equals(pClass)) continue;
                childCopy = this.copy(child, copiedObjects);
                setMethod.invoke((Object)beanCopy, childCopy);
                continue;
            }
            catch (Exception ex) {
                throw new DOMCodecException(ex);
            }
        }
        return beanCopy;
    }

    public Document createDocument(Object bean) throws DOMCodecException {
        Document document = this.db.newDocument();
        Class<?> c = bean.getClass();
        String pPackName = c.getPackage().getName();
        String elementName = c.getName().substring(pPackName.length() + 1);
        elementName = elementName.replace('$', '_');
        if (!this.elementNameUpperCase) {
            elementName = new String(elementName.substring(0, 1).toLowerCase(Locale.ENGLISH) + elementName.substring(1));
        }
        Element e = document.createElement(elementName);
        document.appendChild(e);
        try {
            this.appendToDOM(document, e, bean);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DOMCodecException(ex);
        }
        return document;
    }

    private String getAttributePropertyName(String pdName) {
        if (attributePrefix == null) {
            return null;
        }
        if (pdName.startsWith(attributePrefix)) {
            String attrName = pdName.substring(attributePrefix.length());
            attrName = new String(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH) + attrName.substring(1));
            return attrName;
        }
        return null;
    }

    public void appendToDOM(Document d, Element e, Object bean) throws DOMCodecException {
        this.appendToDOM(d, e, bean, false);
    }

    public void appendToDOM(Document d, Element e, Object bean, boolean appendIfDefault) throws DOMCodecException {
        int n;
        int n2;
        Object[] objectArray;
        Type[] types;
        BeanInfo bi = null;
        Class<?> c = bean.getClass();
        d = e instanceof Document ? (Document)((Object)e) : e.getOwnerDocument();
        for (Type t : types = c.getGenericInterfaces()) {
            if (!t.equals(DOMElementConvertible.class)) continue;
            e.appendChild(((DOMElementConvertible)bean).toElement(d));
            return;
        }
        Object beanDefault = null;
        try {
            bi = Introspector.getBeanInfo(c);
            if (!Number.class.isAssignableFrom(c)) {
                beanDefault = c.newInstance();
            }
        }
        catch (Exception ex) {
            throw new DOMCodecException(ex);
        }
        PropertyDescriptor[] allPds = bi.getPropertyDescriptors();
        PropertyDescriptor[] pds = null;
        DOMElements domElementsAnnot = c.getAnnotation(DOMElements.class);
        String[] domElementNames = null;
        DOMTextNodePropertyName domTextNodePropAnnot = c.getAnnotation(DOMTextNodePropertyName.class);
        String domTextNodePropertyName = null;
        boolean domTextNodeAsCDATA = false;
        if (domTextNodePropAnnot != null) {
            domTextNodePropertyName = domTextNodePropAnnot.value();
            domTextNodeAsCDATA = domTextNodePropAnnot.asCDATANode();
        }
        DOMAttributes domAttributesAnnot = c.getAnnotation(DOMAttributes.class);
        String[] domAttributeNames = null;
        if (domAttributesAnnot != null) {
            domAttributeNames = domAttributesAnnot.value();
        }
        if (domElementsAnnot != null) {
            domElementNames = domElementsAnnot.value();
            ArrayList<PropertyDescriptor> pdsTmp = new ArrayList<PropertyDescriptor>();
            objectArray = domElementNames;
            n2 = objectArray.length;
            block29: for (n = 0; n < n2; ++n) {
                Object elmName = objectArray[n];
                for (PropertyDescriptor pd : allPds) {
                    if (!pd.getName().equals(elmName)) continue;
                    pdsTmp.add(pd);
                    continue block29;
                }
            }
            pds = pdsTmp.toArray(new PropertyDescriptor[0]);
        } else if (domAttributeNames != null) {
            String[] pdsArrList = new ArrayList();
            objectArray = allPds;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                Object pd = objectArray[n];
                boolean isAttr = false;
                for (String a : domAttributeNames) {
                    if (!((FeatureDescriptor)pd).getName().equals(a)) continue;
                    isAttr = true;
                    break;
                }
                if (isAttr) continue;
                pdsArrList.add(pd);
            }
            pds = pdsArrList.toArray(new PropertyDescriptor[0]);
        } else {
            pds = allPds;
        }
        if (domAttributeNames != null) {
            for (String attrName : domAttributeNames) {
                for (int i = 0; i < allPds.length; ++i) {
                    String attrText;
                    PropertyDescriptor pd = allPds[i];
                    String pdName = pd.getName();
                    if (!pdName.equals(attrName)) continue;
                    Method getMethod = pd.getReadMethod();
                    Object child = null;
                    Object defChild = null;
                    try {
                        child = getMethod.invoke(bean, new Object[0]);
                        defChild = getMethod.invoke(beanDefault, new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new DOMCodecException(ex);
                    }
                    if (child == null || defChild != null && defChild.equals(child)) continue;
                    Class<?> childClass = child.getClass();
                    if (Date.class.isAssignableFrom(childClass)) {
                        RFC3339DateTimeFormat rfcDateTimeFormat = new RFC3339DateTimeFormat();
                        PropertyDescriptor[] temporalAnno = getMethod.getAnnotation(Temporal.class);
                        if (temporalAnno != null && Temporal.Type.DATE.equals((Object)temporalAnno.type())) {
                            rfcDateTimeFormat.setTemporalType(RFC3339DateTimeFormat.TemporalType.DATE);
                        }
                        attrText = rfcDateTimeFormat.format(child);
                    } else {
                        attrText = child.toString();
                    }
                    e.setAttribute(attrName, attrText);
                }
            }
        } else {
            for (int i = 0; i < allPds.length; ++i) {
                String attrName;
                PropertyDescriptor pd = allPds[i];
                Class<?> pClass = pd.getPropertyType();
                Method getMethod = pd.getReadMethod();
                String pdName = pd.getName();
                Object child = null;
                Object defChild = null;
                try {
                    child = getMethod.invoke(bean, new Object[0]);
                    defChild = getMethod.invoke(beanDefault, new Object[0]);
                }
                catch (Exception ex) {
                    throw new DOMCodecException(ex);
                }
                if (pClass.equals(String.class)) {
                    if (child == null || defChild != null && ((String)defChild).equals((String)child) || !pdName.startsWith(attributePrefix)) continue;
                    attrName = pdName.substring(attributePrefix.length());
                    attrName = new String(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH) + attrName.substring(1));
                    e.setAttribute(attrName, (String)child);
                    continue;
                }
                if (!pClass.isPrimitive() || child == null || defChild != null && defChild.equals(child) || !pdName.startsWith(attributePrefix)) continue;
                attrName = pdName.substring(attributePrefix.length());
                attrName = new String(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH) + attrName.substring(1));
                e.setAttribute(attrName, child.toString());
            }
        }
        if (domTextNodePropertyName != null) {
            for (int i = 0; i < allPds.length; ++i) {
                PropertyDescriptor pd = allPds[i];
                if (!domTextNodePropertyName.equals(pd.getName())) continue;
                Class<?> pClass = pd.getPropertyType();
                Method getMethod = pd.getReadMethod();
                if (!String.class.equals(pClass)) {
                    throw new DOMCodecException("Text node property \"" + domTextNodePropertyName + "\" must be String type!");
                }
                Object child = null;
                try {
                    child = getMethod.invoke(bean, new Object[0]);
                }
                catch (Exception ex) {
                    throw new DOMCodecException(ex);
                }
                if (child == null) continue;
                if (domTextNodeAsCDATA) {
                    e.appendChild(d.createCDATASection((String)child));
                    continue;
                }
                e.setTextContent((String)child);
            }
        }
        block37: for (int i = 0; i < pds.length; ++i) {
            Element se;
            Element se2;
            String attrName;
            Object se3;
            String pdElementName;
            Element se4;
            DOMCollectionElement domCollElemAnno;
            String collElementName;
            LinkID linkIdanno;
            Method arrChGetMethod;
            PropertyDescriptor[] arrChPds;
            Object collClass;
            Type collParametrizedType;
            ParameterizedType prt;
            Type rt;
            PropertyDescriptor collChLinkIDPd;
            LinkID linkIdanno2;
            PropertyDescriptor pd = pds[i];
            Class<?> pClass = pd.getPropertyType();
            Method getMethod = pd.getReadMethod();
            DOMElement propElemAnno = getMethod.getAnnotation(DOMElement.class);
            String pdName = pd.getName();
            Object child = null;
            Object defChild = null;
            try {
                child = getMethod.invoke(bean, new Object[0]);
                defChild = getMethod.invoke(beanDefault, new Object[0]);
            }
            catch (Exception ex) {
                throw new DOMCodecException(ex);
            }
            if (pClass.isArray()) {
                if (child == null || defChild != null && defChild.equals(child)) continue;
                Class<?> arrClass = pClass.getComponentType();
                DOMRoot domRootAnno = arrClass.getAnnotation(DOMRoot.class);
                PropertyDescriptor arrChLinkIDPd = null;
                if (domRootAnno != null) {
                    PropertyDescriptor[] arrChPds2;
                    BeanInfo arrChBi = null;
                    try {
                        arrChBi = Introspector.getBeanInfo(arrClass);
                    }
                    catch (IntrospectionException e1) {
                        throw new DOMCodecException(e1);
                    }
                    for (PropertyDescriptor arrChPd : arrChPds2 = arrChBi.getPropertyDescriptors()) {
                        Method arrChGetMethod2 = arrChPd.getReadMethod();
                        linkIdanno2 = arrChGetMethod2.getAnnotation(LinkID.class);
                        if (linkIdanno2 == null) continue;
                        arrChLinkIDPd = arrChPd;
                        break;
                    }
                }
                if (arrClass.isArray()) {
                    throw new DOMCodecException("Multidimension arrays cannot be mapped !");
                }
                if (child == null) continue;
                for (int a = 0; a < Array.getLength(child); ++a) {
                    Element se5;
                    Object arrChild = Array.get(child, a);
                    if (arrClass.equals(String.class)) {
                        se5 = d.createElement(pdName);
                        se5.appendChild(d.createTextNode((String)arrChild));
                        e.appendChild(se5);
                        continue;
                    }
                    if (arrClass.isPrimitive()) {
                        se5 = d.createElement(pdName);
                        se5.appendChild(d.createTextNode(arrChild.toString()));
                        e.appendChild(se5);
                        continue;
                    }
                    if (arrClass.equals(Boolean.class)) {
                        se5 = d.createElement(pdName);
                        se5.appendChild(d.createTextNode(arrChild.toString()));
                        e.appendChild(se5);
                        continue;
                    }
                    if (pClass.equals(Class.class)) continue;
                    String pdElementName2 = null;
                    if (propElemAnno != null) {
                        pdElementName2 = propElemAnno.name();
                    }
                    if (pdElementName2 == null) {
                        if (this.elementNameUpperCase) {
                            pdElementName2 = pdName.substring(0, 1).toUpperCase(Locale.ENGLISH);
                            pdElementName2 = pdElementName2.concat(pd.getName().substring(1));
                        } else {
                            pdElementName2 = new String(pdName);
                        }
                    }
                    Element se6 = d.createElement(pdElementName2);
                    e.appendChild(se6);
                    if (arrChild == null) continue;
                    if (domRootAnno != null) {
                        Object linkVal;
                        Method rMethod = arrChLinkIDPd.getReadMethod();
                        try {
                            linkVal = rMethod.invoke(arrChild, new Object[0]);
                        }
                        catch (Exception e1) {
                            throw new DOMCodecException(e1);
                        }
                        se6.setAttribute(arrChLinkIDPd.getName(), linkVal.toString());
                        continue;
                    }
                    boolean appIfDefault = true;
                    RemoveIfDefault riDAnnot = getMethod.getAnnotation(RemoveIfDefault.class);
                    if (riDAnnot != null) {
                        appIfDefault = false;
                    }
                    this.appendToDOM(d, se6, arrChild, appIfDefault);
                }
                continue;
            }
            if (List.class.isAssignableFrom(pClass)) {
                DOMRoot domRootAnno;
                Type[] prtTypes;
                if (child == null || defChild != null && defChild.equals(child)) continue;
                collChLinkIDPd = null;
                rt = pd.getReadMethod().getGenericReturnType();
                if (rt instanceof ParameterizedType && (prtTypes = (prt = (ParameterizedType)rt).getActualTypeArguments()) != null && prtTypes.length == 1 && (collParametrizedType = prtTypes[0]) instanceof Class && (domRootAnno = ((Class)(collClass = (Class)collParametrizedType)).getAnnotation(DOMRoot.class)) != null) {
                    BeanInfo collChBi = null;
                    try {
                        collChBi = Introspector.getBeanInfo(collClass);
                    }
                    catch (IntrospectionException e1) {
                        throw new DOMCodecException(e1);
                    }
                    for (PropertyDescriptor arrChPd : arrChPds = collChBi.getPropertyDescriptors()) {
                        arrChGetMethod = arrChPd.getReadMethod();
                        linkIdanno = arrChGetMethod.getAnnotation(LinkID.class);
                        if (linkIdanno == null) continue;
                        collChLinkIDPd = arrChPd;
                        break;
                    }
                }
                collElementName = null;
                Element collParent = e;
                domCollElemAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                if (domCollElemAnno != null) {
                    collElementName = domCollElemAnno.collectionElementName();
                    collParent = d.createElement(pdName);
                    e.appendChild(collParent);
                } else {
                    collParent = e;
                }
                collClass = ((List)child).iterator();
                while (collClass.hasNext()) {
                    Object setChild = collClass.next();
                    Class<?> setClass = setChild.getClass();
                    if (String.class.equals(setClass)) {
                        se4 = d.createElement(pdName);
                        se4.appendChild(d.createTextNode((String)setChild));
                        collParent.appendChild(se4);
                        continue;
                    }
                    if (setClass.isPrimitive()) {
                        se4 = d.createElement(pdName);
                        se4.appendChild(d.createTextNode(setChild.toString()));
                        collParent.appendChild(se4);
                        continue;
                    }
                    if (Class.class.equals(setClass)) continue;
                    pdElementName = null;
                    if (propElemAnno != null) {
                        pdElementName = propElemAnno.name();
                    }
                    if (pdElementName == null) {
                        if (this.elementNameUpperCase) {
                            pdElementName = pdName.substring(0, 1).toUpperCase(Locale.ENGLISH);
                            pdElementName = pdElementName.concat(pd.getName().substring(1));
                        } else {
                            pdElementName = new String(pdName);
                        }
                    }
                    se3 = null;
                    se3 = collElementName == null ? d.createElement(pdElementName) : d.createElement(collElementName);
                    collParent.appendChild((Node)se3);
                    if (setChild == null) continue;
                    if (collChLinkIDPd != null) {
                        Object linkVal;
                        Method rMethod = collChLinkIDPd.getReadMethod();
                        try {
                            linkVal = rMethod.invoke(setChild, new Object[0]);
                        }
                        catch (Exception e1) {
                            throw new DOMCodecException(e1);
                        }
                        se3.setAttribute(collChLinkIDPd.getName(), linkVal.toString());
                        continue;
                    }
                    boolean appIfDefault = true;
                    RemoveIfDefault riDAnnot = getMethod.getAnnotation(RemoveIfDefault.class);
                    if (riDAnnot != null) {
                        appIfDefault = false;
                    }
                    this.appendToDOM(d, (Element)se3, setChild, appIfDefault);
                }
                continue;
            }
            if (Set.class.isAssignableFrom(pClass)) {
                DOMRoot domRootAnno;
                Type[] prtTypes;
                if (child == null || defChild != null && defChild.equals(child)) continue;
                collChLinkIDPd = null;
                rt = pd.getReadMethod().getGenericReturnType();
                if (rt instanceof ParameterizedType && (prtTypes = (prt = (ParameterizedType)rt).getActualTypeArguments()) != null && prtTypes.length == 1 && (collParametrizedType = prtTypes[0]) instanceof Class && (domRootAnno = ((Class)(collClass = (Class)collParametrizedType)).getAnnotation(DOMRoot.class)) != null) {
                    BeanInfo collChBi = null;
                    try {
                        collChBi = Introspector.getBeanInfo(collClass);
                    }
                    catch (IntrospectionException e1) {
                        throw new DOMCodecException(e1);
                    }
                    arrChPds = collChBi.getPropertyDescriptors();
                    for (PropertyDescriptor arrChPd : arrChPds) {
                        arrChGetMethod = arrChPd.getReadMethod();
                        linkIdanno = arrChGetMethod.getAnnotation(LinkID.class);
                        if (linkIdanno == null) continue;
                        collChLinkIDPd = arrChPd;
                        break;
                    }
                }
                collElementName = null;
                Element collParent = e;
                domCollElemAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                if (domCollElemAnno != null) {
                    collElementName = domCollElemAnno.collectionElementName();
                    collParent = d.createElement(pdName);
                    e.appendChild(collParent);
                } else {
                    collParent = e;
                }
                collClass = ((Set)child).iterator();
                while (collClass.hasNext()) {
                    Object setChild = collClass.next();
                    Class<?> setClass = setChild.getClass();
                    if (String.class.equals(setClass)) {
                        se4 = d.createElement(pdName);
                        se4.appendChild(d.createTextNode((String)setChild));
                        collParent.appendChild(se4);
                        continue;
                    }
                    if (setClass.isPrimitive()) {
                        se4 = d.createElement(pdName);
                        se4.appendChild(d.createTextNode(setChild.toString()));
                        collParent.appendChild(se4);
                        continue;
                    }
                    if (Class.class.equals(setClass)) continue;
                    pdElementName = null;
                    if (propElemAnno != null) {
                        pdElementName = propElemAnno.name();
                    }
                    if (pdElementName == null) {
                        if (this.elementNameUpperCase) {
                            pdElementName = pdName.substring(0, 1).toUpperCase(Locale.ENGLISH);
                            pdElementName = pdElementName.concat(pd.getName().substring(1));
                        } else {
                            pdElementName = new String(pdName);
                        }
                    }
                    se3 = null;
                    se3 = collElementName == null ? d.createElement(pdElementName) : d.createElement(collElementName);
                    collParent.appendChild((Node)se3);
                    if (setChild == null) continue;
                    if (collChLinkIDPd != null) {
                        Object linkVal;
                        Method rMethod = collChLinkIDPd.getReadMethod();
                        try {
                            linkVal = rMethod.invoke(setChild, new Object[0]);
                        }
                        catch (Exception e1) {
                            throw new DOMCodecException(e1);
                        }
                        se3.setAttribute(collChLinkIDPd.getName(), linkVal.toString());
                        continue;
                    }
                    boolean appIfDefault = true;
                    RemoveIfDefault riDAnnot = getMethod.getAnnotation(RemoveIfDefault.class);
                    if (riDAnnot != null) {
                        appIfDefault = false;
                    }
                    this.appendToDOM(d, (Element)se3, setChild, appIfDefault);
                }
                continue;
            }
            if (Map.class.isAssignableFrom(pClass)) {
                Class keyClass;
                DOMRoot domRootAnno;
                Type keyParametrizedType;
                Type[] prtTypes;
                if (child == null || defChild != null && defChild.equals(child)) continue;
                collChLinkIDPd = null;
                rt = pd.getReadMethod().getGenericReturnType();
                if (rt instanceof ParameterizedType && (prtTypes = (prt = (ParameterizedType)rt).getActualTypeArguments()) != null && prtTypes.length == 2 && (keyParametrizedType = prtTypes[0]) instanceof Class && (domRootAnno = (keyClass = (Class)keyParametrizedType).getAnnotation(DOMRoot.class)) != null) {
                    BeanInfo collChBi = null;
                    try {
                        collChBi = Introspector.getBeanInfo(keyClass);
                    }
                    catch (IntrospectionException e1) {
                        throw new DOMCodecException(e1);
                    }
                    arrChPds = collChBi.getPropertyDescriptors();
                    for (PropertyDescriptor arrChPd : arrChPds) {
                        arrChGetMethod = arrChPd.getReadMethod();
                        linkIdanno = arrChGetMethod.getAnnotation(LinkID.class);
                        if (linkIdanno == null) continue;
                        collChLinkIDPd = arrChPd;
                        break;
                    }
                }
                collElementName = null;
                Element collParent = e;
                domCollElemAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                if (domCollElemAnno != null) {
                    collElementName = domCollElemAnno.collectionElementName();
                    collParent = d.createElement(pdName);
                    e.appendChild(collParent);
                } else {
                    collParent = e;
                }
                Element gse = d.createElement(pdName);
                collParent.appendChild(gse);
                Map m = (Map)child;
                Set keySet = m.keySet();
                arrChPds = keySet.iterator();
                while (arrChPds.hasNext()) {
                    Object valChild;
                    Object keyChild = arrChPds.next();
                    Element se7 = d.createElement("entry");
                    gse.appendChild(se7);
                    if (keyChild != null) {
                        Node keyNode = se7.appendChild(d.createElement("key"));
                        Class<?> keyClass2 = keyChild.getClass();
                        if (String.class.equals(keyClass2)) {
                            keyNode.appendChild(d.createTextNode((String)keyChild));
                        } else if (keyClass2.isPrimitive()) {
                            keyNode.appendChild(d.createTextNode(keyChild.toString()));
                        } else if (!Class.class.equals(keyClass2)) {
                            throw new DOMCodecException("For maps type of key is restricted to String or primitive type!");
                        }
                    }
                    if ((valChild = m.get(keyChild)) == null) continue;
                    Node valNode = se7.appendChild(d.createElement("value"));
                    Class<?> valClass = valChild.getClass();
                    if (String.class.equals(valClass)) {
                        valNode.appendChild(d.createTextNode((String)valChild));
                        continue;
                    }
                    if (valClass.isPrimitive()) {
                        valNode.appendChild(d.createTextNode(valChild.toString()));
                        continue;
                    }
                    if (Class.class.equals(valClass)) continue;
                    throw new DOMCodecException("For maps type of kex is resctricteed to String or primitive type!");
                }
                continue;
            }
            if (pClass.isEnum()) {
                if (child == null || defChild != null && defChild.equals(child)) continue;
                if (pdName.startsWith(attributePrefix)) {
                    attrName = pdName.substring(attributePrefix.length());
                    attrName = new String(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH) + attrName.substring(1));
                    e.setAttribute(attrName, child.toString());
                    continue;
                }
                se2 = d.createElement(pdName);
                se2.appendChild(d.createTextNode(child.toString()));
                e.appendChild(se2);
                continue;
            }
            if (pClass.equals(String.class)) {
                if (child == null || defChild != null && ((String)defChild).equals((String)child)) continue;
                if (pdName.startsWith(attributePrefix)) {
                    attrName = pdName.substring(attributePrefix.length());
                    attrName = new String(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH) + attrName.substring(1));
                    e.setAttribute(attrName, (String)child);
                    continue;
                }
                if (pdName.equals(domTextNodePropertyName)) continue;
                se2 = d.createElement(pdName);
                se2.appendChild(d.createTextNode((String)child));
                e.appendChild(se2);
                continue;
            }
            if (Date.class.isAssignableFrom(pClass)) {
                if (child == null || defChild != null && ((Date)defChild).equals((Date)child)) continue;
                RFC3339DateTimeFormat dateFormat = new RFC3339DateTimeFormat();
                Temporal temporalAnno = getMethod.getAnnotation(Temporal.class);
                if (temporalAnno != null && Temporal.Type.DATE.equals((Object)temporalAnno.type())) {
                    dateFormat.setTemporalType(RFC3339DateTimeFormat.TemporalType.DATE);
                }
                String formattedDateStr = dateFormat.format(child);
                if (pdName.startsWith(attributePrefix)) {
                    String attrName2 = pdName.substring(attributePrefix.length());
                    attrName2 = new String(attrName2.substring(0, 1).toLowerCase(Locale.ENGLISH) + attrName2.substring(1));
                    e.setAttribute(attrName2, formattedDateStr);
                    continue;
                }
                Element se8 = d.createElement(pdName);
                se8.appendChild(d.createTextNode(formattedDateStr));
                e.appendChild(se8);
                continue;
            }
            if (UUID.class.isAssignableFrom(pClass)) {
                if (child == null || defChild != null && ((UUID)defChild).equals((UUID)child)) continue;
                String uuidStr = child.toString();
                if (pdName.startsWith(attributePrefix)) {
                    String attrName3 = pdName.substring(attributePrefix.length());
                    attrName3 = new String(attrName3.substring(0, 1).toLowerCase(Locale.ENGLISH) + attrName3.substring(1));
                    e.setAttribute(attrName3, uuidStr);
                    continue;
                }
                se = d.createElement(pdName);
                se.appendChild(d.createTextNode(uuidStr));
                e.appendChild(se);
                continue;
            }
            if (pClass.equals(Boolean.class)) {
                if (child == null || defChild != null && defChild.equals(child)) continue;
                if (pdName.startsWith(attributePrefix)) {
                    attrName = pdName.substring(attributePrefix.length());
                    attrName = new String(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH) + attrName.substring(1));
                    e.setAttribute(attrName, child.toString());
                    continue;
                }
                se2 = d.createElement(pdName);
                se2.appendChild(d.createTextNode(child.toString()));
                e.appendChild(se2);
                continue;
            }
            if (pClass.isPrimitive() || Number.class.isAssignableFrom(pClass)) {
                if (child == null || defChild != null && defChild.equals(child)) continue;
                if (pdName.startsWith(attributePrefix)) {
                    attrName = pdName.substring(attributePrefix.length());
                    attrName = new String(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH) + attrName.substring(1));
                    e.setAttribute(attrName, child.toString());
                    continue;
                }
                se2 = d.createElement(pdName);
                se2.appendChild(d.createTextNode(child.toString()));
                e.appendChild(se2);
                continue;
            }
            if (pClass.equals(Class.class) || child == null) continue;
            String pdElementName3 = null;
            if (propElemAnno != null) {
                pdElementName3 = propElemAnno.name();
            }
            if (pdElementName3 == null) {
                if (this.elementNameUpperCase) {
                    pdElementName3 = pdName.substring(0, 1).toUpperCase(Locale.ENGLISH);
                    pdElementName3 = pdElementName3.concat(pd.getName().substring(1));
                } else {
                    pdElementName3 = new String(pdName);
                }
            }
            se = d.createElement(pdElementName3);
            e.appendChild(se);
            DOMRoot domRootAnno = pClass.getAnnotation(DOMRoot.class);
            if (domRootAnno != null) {
                PropertyDescriptor[] chPds;
                BeanInfo chBi = null;
                try {
                    chBi = Introspector.getBeanInfo(pClass);
                }
                catch (IntrospectionException e1) {
                    throw new DOMCodecException(e1);
                }
                for (PropertyDescriptor chPd : chPds = chBi.getPropertyDescriptors()) {
                    Method chGetMethod = chPd.getReadMethod();
                    linkIdanno2 = chGetMethod.getAnnotation(LinkID.class);
                    if (linkIdanno2 == null) continue;
                    String linkIDpropname = chPd.getName();
                    try {
                        Object linkVal = chGetMethod.invoke(child, new Object[0]);
                        se.setAttribute(linkIDpropname, linkVal.toString());
                        continue block37;
                    }
                    catch (Exception e1) {
                        throw new DOMCodecException(e1);
                    }
                }
                continue;
            }
            this.appendToDOM(d, se, child);
        }
        if (!appendIfDefault) {
            NodeList nl = e.getChildNodes();
            boolean isEmpty = true;
            for (int l = 0; l < nl.getLength(); ++l) {
                Node n3 = nl.item(l);
                short nodeType = n3.getNodeType();
                if (nodeType != 2 && nodeType != 1 && nodeType != 3 && nodeType != 9) continue;
                isEmpty = false;
            }
            NamedNodeMap nMap = e.getAttributes();
            if (nMap.getLength() > 0) {
                isEmpty = false;
            }
            Node parent = e.getParentNode();
            if (isEmpty && parent.getNodeType() != 9) {
                parent.removeChild(e);
            }
        }
    }

    public static void main(String[] args) {
        File f = new File("test.xml");
        try {
            Package basePack = Class.forName("ipsk.beans.test.Root").getPackage();
            DOMCodec ph = new DOMCodec(basePack, false);
            DOMConverter dc = new DOMConverter();
            Root r = new Root();
            r.setRouting(new int[]{3, 5});
            r.setAttributeId("test");
            r.setAnnotatedTestAttribute("testAttribut Annotated");
            r.setName("Heyhey");
            HashSet<Child1> childrenSet = new HashSet<Child1>();
            Child1 childrenSet1 = new Child1();
            childrenSet1.setSampleRate(96000.0f);
            Child1 childrenSet2 = new Child1();
            childrenSet2.setSampleRate(24000.0f);
            childrenSet.add(childrenSet1);
            childrenSet.add(childrenSet2);
            r.setChildrenSet(childrenSet);
            String s1 = "Erstes String element";
            String s2 = "Zweites String element";
            String[] sd1 = new String[]{s1, s2};
            r.setMixerNames(sd1);
            r.setWeekDay(Root.WeekDays.WEDNESDAY);
            r.setTextContent("Dies ist Text!");
            Child1 c1 = new Child1();
            c1.setSampleSizes(new int[]{8, 16, 24, 32});
            c1.setAttributeSelection(Child1.Selection.GREEN);
            c1.setAttributeType("NORM");
            r.setChild(new Child1[]{c1});
            Child1 c3 = new Child1();
            c3.setSampleRate(128000.0f);
            r.setAnotherChild(new Child1[]{c3, c3});
            Document d = ph.createDocument(r);
            FileOutputStream fos = new FileOutputStream(f);
            dc.writeXML(d, new OutputStreamWriter(System.out));
            dc.writeXML(d, new OutputStreamWriter(fos));
            fos.close();
            Document d2 = dc.readXML(new FileInputStream(f));
            Root rr = (Root)ph.readDocument(d2);
            System.out.println(rr.getName() + " " + rr.getChild()[0].getAttributeType() + " " + rr.getTextContent());
            ph.createDocument(new SuperRoot());
        }
        catch (DOMCodecException e) {
            e.printStackTrace();
        }
        catch (DOMConverterException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

