/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net.http;

import ipsk.net.UploadCache;
import ipsk.net.UploadException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpUploadCache
extends UploadCache {
    private Logger logger;
    private int responseCode = 0;
    private Vector<String> sessionCookies = new Vector();
    private boolean acceptCookies = false;

    public HttpUploadCache() {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logger.setLevel(Level.FINEST);
        this.bufSize = DEFAULT_BUFSIZE;
        this.buffer = new byte[this.bufSize];
        this.totalLength = 0L;
        this.toUploadLength = 0L;
        this.guessedToUploadLength = 0L;
        this.holdLength = 0L;
        this.holdSize = 0L;
        this.totalUploadLength = 0L;
        this.connectedTimeInMillis = 0L;
        this.byteRate = 0.0f;
        this.idle = true;
        this.synced = true;
        this.requestMethod = "POST";
    }

    public void setSessionCookies(String[] sessionCookies) {
        for (int i = 0; i < sessionCookies.length; ++i) {
            this.sessionCookies.add(sessionCookies[i]);
        }
    }

    private boolean tryConnect() {
        int retryCount = 0;
        int idleCount = 0;
        do {
            this.getNextUpload();
            while (this.currentUpload == null && this.running) {
                this.fireFinished();
                try {
                    Thread.sleep(ON_IDLE_DELAY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++idleCount;
                this.getNextUpload();
            }
            if (!this.running) {
                return false;
            }
            this.idle = false;
            this.fireTryConnect();
            this.logger.fine("Try connect...");
            try {
                this.connection = this.currentStream.getUrl().openConnection();
                if (this.sessionCookies != null) {
                    for (int i = 0; i < this.sessionCookies.size(); ++i) {
                        this.connection.addRequestProperty("Cookie", this.sessionCookies.get(i));
                    }
                    this.connection.setAllowUserInteraction(true);
                }
                long contentLength = this.currentStream.getLength();
                this.logger.info("Content length of upload: " + contentLength);
                if (contentLength > 0L && contentLength <= Integer.MAX_VALUE) {
                    ((HttpURLConnection)this.connection).setFixedLengthStreamingMode((int)contentLength);
                }
                this.connection.addRequestProperty("Content-length", new Long(this.currentStream.getLength()).toString());
                this.connection.setDoOutput(true);
                if (this.connection instanceof HttpURLConnection) {
                    HttpURLConnection httpConn = (HttpURLConnection)this.connection;
                    httpConn.setRequestMethod(this.requestMethod);
                    String mimeType = this.currentStream.getMimeType();
                    if (mimeType != null) {
                        httpConn.setRequestProperty("Content-type", mimeType);
                    } else {
                        httpConn.setRequestProperty("Content-type", "application/octet-stream");
                    }
                }
                this.connection.connect();
            }
            catch (IOException e) {
                this.responseMessage = new String("Cannot connect. Retry # " + retryCount);
                this.logger.warning(this.responseMessage + " " + e.getLocalizedMessage());
                this.fireStateChanged(null);
                if (!this.running) break;
                try {
                    Thread.sleep(CONNECT_RETRY_DELAY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++retryCount <= DEFAULT_CONNECT_RETRIES) continue;
                this.responseMessage = new String("Cannot connect.");
                this.fireStateChanged(null);
                this.running = false;
                break;
            }
            this.connected = true;
            this.logger.fine("Connected.");
            this.fireConnected();
            return true;
        } while (this.running);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (this.tryConnect()) {
            block61: {
                block63: {
                    block62: {
                        this.startConnect = System.currentTimeMillis();
                        this.logger.fine("starting upload");
                        this.synced = false;
                        try {
                            try {
                                this.inputStream = this.currentStream.getInputStream();
                            }
                            catch (UploadException e) {
                                this.logger.severe("Cannot get input stream: " + e.getMessage());
                                this.currentStream.setStatus(2);
                                this.synced = true;
                                try {
                                    if (this.inputStream != null) {
                                        this.inputStream.close();
                                    }
                                    if (this.outputStream != null) {
                                        this.outputStream.close();
                                    }
                                }
                                catch (IOException e1) {
                                    this.logger.severe("Close error: " + e1.getMessage());
                                    this.currentStream.setStatus(-1);
                                }
                                this.calculateLength();
                                this.fireStateChanged(this.currentStream);
                                this.connected = false;
                                this.fireDisconnected();
                                break block61;
                            }
                            this.outputStream = this.connection.getOutputStream();
                            read = 0;
                            this.guessedToUploadLength = this.toUploadLength;
                            this.currentStream.setStatus(1);
                            this.fireStateChanged(this.currentStream);
                            ** try [egrp 4[TRYBLOCK] [6, 11 : 192->257)] { 
lbl33:
                            // 1 sources

                            break block62;
lbl34:
                            // 1 sources

                            catch (IOException e) {
                                this.logger.severe("Cannot upload !: " + e.getMessage());
                                this.currentStream.setStatus(-1);
                                break block63;
                            }
                        }
                        catch (Exception e) {
                            this.logger.severe("Cannot upload !: " + e.getMessage());
                            this.currentStream.setStatus(-1);
                            if (this.uploadRetryCount > HttpUploadCache.UPLOAD_RETRIES) {
                                this.responseMessage = "Exception: " + e.getMessage();
                                this.fireStateChanged(null);
                                this.running = false;
                                break;
                            }
                            try {
                                Thread.sleep(HttpUploadCache.UPLOAD_RETRY_DELAY);
                            }
                            catch (InterruptedException var2_15) {
                                // empty catch block
                            }
                            ++this.uploadRetryCount;
                            break block61;
                        }
                    }
                    while (read >= 0) {
                        read = this.inputStream.read(this.buffer, 0, this.buffer.length);
                        if (read > 0) {
                            this.outputStream.write(this.buffer, 0, read);
                        }
                        Thread.sleep(2L);
                        if (HttpUploadCache.DEBUG_DELAY <= 0) continue;
                        try {
                            Thread.sleep(HttpUploadCache.DEBUG_DELAY);
                        }
                        catch (InterruptedException e1) {}
                    }
                    break block63;
lbl66:
                    // 1 sources

                    finally {
                        try {
                            if (this.inputStream != null) {
                                this.inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            this.logger.severe("Close error !: " + e.getMessage());
                        }
                        finally {
                            if (this.outputStream != null) {
                                this.outputStream.close();
                            }
                        }
                    }
                }
                if (this.connection instanceof HttpURLConnection) {
                    this.responseCode = ((HttpURLConnection)this.connection).getResponseCode();
                    this.responseMessage = ((HttpURLConnection)this.connection).getResponseMessage();
                    if (this.responseCode >= 400 || this.responseCode < 200) {
                        this.logger.warning("Upload failed: " + this.currentStream);
                        this.logger.warning("HTTP: " + this.responseMessage + ", " + this.responseCode);
                        this.currentStream.setStatus(-1);
                        if (this.uploadRetryCount > HttpUploadCache.UPLOAD_RETRIES) {
                            this.fireStateChanged(null);
                            this.running = false;
                            break;
                        }
                        Thread.sleep(HttpUploadCache.UPLOAD_RETRY_DELAY);
                        ++this.uploadRetryCount;
                        break block61;
                    } else {
                        ++this.currentStreamIndex;
                        if (this.currentStreamIndex == this.currentUpload.length) {
                            this.currentStreamIndex = 0;
                            this.currentUpload = null;
                        }
                        this.connectedTimeInMillis += System.currentTimeMillis() - this.startConnect;
                        this.totalUploadLength += this.currentStream.getLength();
                        this.logger.info("Uploaded: " + this.currentStream);
                        this.currentStream.setStatus(3);
                        if (this.acceptCookies && (cookie = ((HttpURLConnection)this.connection).getHeaderField("Set-Cookie")) != null) {
                            this.sessionCookies.add(cookie);
                        }
                        this.logger.info("HTTP: " + this.responseMessage + ", " + this.responseCode);
                    }
                }
                break block61;
                finally {
                    this.synced = true;
                    try {
                        if (this.inputStream != null) {
                            this.inputStream.close();
                        }
                        if (this.outputStream != null) {
                            this.outputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        this.logger.severe("Close error: " + e1.getMessage());
                        this.currentStream.setStatus(-1);
                    }
                    this.calculateLength();
                    this.fireStateChanged(this.currentStream);
                    this.connected = false;
                    this.fireDisconnected();
                }
            }
            if (this.running) continue;
        }
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
        this.idle = true;
    }

    public boolean isAcceptCookies() {
        return this.acceptCookies;
    }

    public void setAcceptCookies(boolean b) {
        this.acceptCookies = b;
    }
}

