/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net.http;

import ipsk.net.UploadCache;
import ipsk.net.UploadException;
import ipsk.net.http.HttpUploadCacheExtension;
import ipsk.util.RadixConverters;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SplittingHttpUploadCache
extends UploadCache
implements HttpUploadCacheExtension {
    public static final String STATUS_KEY = "status";
    public static final String STATUS_OK = "OK";
    public static final String UPLOAD_ID_KEY = "id";
    public static final String PARTITIONS_COUNT_KEY = "_parts";
    public static final String PARTITION_NUM_KEY = "_part";
    public static final String CHECK_SUM_TYPE_KEY = "_chsumalg";
    public static final String CHECK_SUM_KEY = "_chsum";
    private static final int MINIMUM_LIMIT = 256;
    private static boolean DEBUG = false;
    private static boolean RANDOMIZE_PART_SIZE = false;
    private static int DEFAULT_SPLIT_LIMIT = 300000;
    private static int DEFAULT_SPLIT_MIN_LIMIT = 10000;
    private static int THREAD_IDLE_TIME = 0;
    public static int MAX_UPLOAD_ATTEMPTS = 4;
    private Logger logger;
    private int responseCode = 0;
    private String encoding;
    private Vector<String> sessionCookies = new Vector();
    private boolean acceptCookies = false;
    private int limit;
    private long totalUploadedBytes = 0L;
    private long totalStartTimeMs = 0L;

    public SplittingHttpUploadCache() {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logger.setLevel(Level.FINEST);
        this.limit = DEFAULT_SPLIT_LIMIT;
        this.bufSize = DEFAULT_BUFSIZE;
        this.buffer = new byte[this.bufSize];
        this.totalLength = 0L;
        this.toUploadLength = 0L;
        this.holdLength = 0L;
        this.holdSize = 0L;
        this.totalUploadLength = 0L;
        this.connectedTimeInMillis = 0L;
        this.byteRate = 0.0f;
        this.idle = true;
        this.synced = true;
        this.requestMethod = "POST";
        this.transferRateLimitSupported = true;
    }

    @Override
    public void setSessionCookies(String[] sessionCookies) {
        for (int i = 0; i < sessionCookies.length; ++i) {
            this.sessionCookies.add(sessionCookies[i]);
        }
    }

    private boolean tryConnect(URL url, int partLength) throws IOException {
        int retryCount = 0;
        do {
            this.idle = false;
            this.fireTryConnect();
            this.logger.info("Try connect...");
            try {
                this.connection = url.openConnection();
                if (DEBUG) {
                    System.out.println("Got connection...");
                }
                if (this.sessionCookies != null) {
                    if (DEBUG) {
                        System.out.println(this.sessionCookies.size() + " Cookies.");
                    }
                    for (int i = 0; i < this.sessionCookies.size(); ++i) {
                        this.connection.addRequestProperty("Cookie", this.sessionCookies.get(i));
                    }
                    this.connection.setAllowUserInteraction(true);
                } else if (DEBUG) {
                    System.out.println("Session cookies null !!");
                }
                this.logger.info("Content length of upload: " + partLength);
                this.connection.addRequestProperty("Content-type", "application/octet-stream");
                this.connection.addRequestProperty("Content-length", new Integer(partLength).toString());
                this.connection.setDoOutput(true);
                this.connection.setDoInput(true);
                if (this.connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)this.connection).setRequestMethod(this.requestMethod);
                    if (DEBUG) {
                        System.out.println("Request method :" + this.requestMethod);
                    }
                } else if (DEBUG) {
                    System.out.println("No HttpURLConnection.");
                }
                this.connection.connect();
            }
            catch (IOException e) {
                this.responseMessage = new String("Cannot connect. Retry # " + retryCount);
                this.logger.warning(this.responseMessage + " " + e.getLocalizedMessage());
                this.fireStateChanged(null);
                if (!this.running) break;
                try {
                    Thread.sleep(CONNECT_RETRY_DELAY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++retryCount <= DEFAULT_CONNECT_RETRIES) continue;
                this.responseMessage = new String("Cannot connect.");
                this.fireStateChanged(null);
                this.running = false;
                throw new IOException("Could not connect!");
            }
            this.connected = true;
            this.logger.info("Connected.");
            this.fireConnected();
            return true;
        } while (this.running);
        return false;
    }

    private URL createURL(String sumDigest, String chsumHex, boolean partioned, int part, int parts, Long uploadId) throws MalformedURLException {
        URL streamUrl = this.currentStream.getUrl();
        String urlStr = streamUrl.toExternalForm();
        if (sumDigest != null || partioned) {
            String q = streamUrl.getQuery();
            urlStr = q == null ? urlStr.concat("?") : urlStr.concat("&");
        }
        if (sumDigest != null) {
            urlStr = urlStr.concat("_chsumalg=" + sumDigest + "&_chsum=" + chsumHex);
        }
        if (partioned) {
            if (!urlStr.endsWith("?") && !urlStr.endsWith("&")) {
                urlStr = urlStr.concat("&");
            }
            urlStr = urlStr.concat("_parts=" + parts + "&_part=" + part);
        }
        if (uploadId != null) {
            if (!urlStr.endsWith("?") && !urlStr.endsWith("&")) {
                urlStr = urlStr.concat("&");
            }
            urlStr = urlStr.concat("id=" + uploadId.toString());
        }
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            this.logger.severe("Cannot create URL for upload: " + e.getMessage());
            this.currentStream.setStatus(2);
            throw e;
        }
        return url;
    }

    private void upload() throws Exception {
        long partsLength;
        URL url = null;
        long contentLength = this.currentStream.getLength();
        ArrayList<Integer> partitionLengths = new ArrayList<Integer>();
        if (RANDOMIZE_PART_SIZE) {
            if (contentLength <= (long)this.limit) {
                partitionLengths.add((int)contentLength);
            } else {
                int pL;
                double randomIntervall = this.limit - DEFAULT_SPLIT_MIN_LIMIT;
                for (partsLength = 0L; partsLength < contentLength; partsLength += (long)pL) {
                    long toDivideLength = contentLength - partsLength;
                    pL = toDivideLength <= (long)this.limit ? (int)toDivideLength : 256 + (int)(Math.random() * randomIntervall);
                    partitionLengths.add(pL);
                }
            }
        } else {
            while (partsLength < contentLength) {
                long pL = contentLength - partsLength;
                if (pL > (long)this.limit) {
                    pL = this.limit;
                }
                partitionLengths.add((int)pL);
                partsLength += pL;
            }
        }
        int parts = partitionLengths.size();
        String sumDigest = this.currentStream.getChecksumDigest();
        String chsumHex = null;
        byte[] chsum = this.currentStream.getChecksum();
        if (sumDigest != null && chsum != null) {
            chsumHex = RadixConverters.bytesToHex(chsum);
        }
        try {
            this.inputStream = this.currentStream.getInputStream();
        }
        catch (UploadException e) {
            this.logger.severe("Cannot get input stream: " + e.getMessage());
            this.currentStream.setStatus(2);
            throw e;
        }
        this.currentStream.setStatus(1);
        this.logger.info("Stream set to uploading state");
        this.fireStateChanged(this.currentStream);
        for (int part = 0; part < parts; ++part) {
            double totalTimeSeconds;
            int partUploadLength = (Integer)partitionLengths.get(part);
            if (parts > 1) {
                this.logger.info("Partition: " + part);
            }
            url = this.createURL(sumDigest, chsumHex, parts > 1, part, parts, this.currentStream.getId());
            this.logger.info("URL created: " + url);
            if (!this.tryConnect(url, partUploadLength)) {
                throw new UploadException("Uploading interrupted");
            }
            this.logger.info("starting upload");
            try {
                this.uploadPart(partUploadLength);
            }
            catch (Exception e) {
                this.logger.severe("Cannot upload part of upload: " + e.getMessage());
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
                throw e;
            }
            long totalTimeMs = System.currentTimeMillis() - this.totalStartTimeMs;
            if (totalTimeMs == 0L) {
                totalTimeMs = 1L;
            }
            if (!((totalTimeSeconds = (double)totalTimeMs / 1000.0) > 0.0)) continue;
            double byteRate = (double)this.totalUploadedBytes / totalTimeSeconds;
            if (this.transferRateLimit == -1 || !(byteRate > (double)this.transferRateLimit)) continue;
            double timeToWaitSeconds = ((double)this.totalUploadedBytes - (double)this.transferRateLimit * totalTimeSeconds) / (double)this.transferRateLimit;
            this.logger.info("Limiting transfer rate: actual: " + byteRate + " quota: " + this.transferRateLimit + " (bytes per second).");
            this.logger.info("Waiting " + timeToWaitSeconds + " s");
            Thread.sleep((int)(timeToWaitSeconds * 1000.0));
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            this.logger.severe("Cannot close input stream: " + e.getMessage());
            this.currentStream.setStatus(-2);
            throw e;
        }
    }

    private void uploadPart(int length) throws Exception {
        try {
            block36: {
                this.outputStream = this.connection.getOutputStream();
                int read = 0;
                int toRead = length;
                block22: while (true) {
                    try {
                        while (read >= 0 && toRead > 0) {
                            int bufToRead = this.buffer.length;
                            if (bufToRead > toRead) {
                                bufToRead = toRead;
                            }
                            if ((read = this.inputStream.read(this.buffer, 0, bufToRead)) > 0) {
                                toRead -= read;
                                this.outputStream.write(this.buffer, 0, read);
                                this.totalUploadedBytes += (long)read;
                            }
                            try {
                                Thread.sleep(2L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (DEBUG_DELAY <= 0) continue;
                            try {
                                Thread.sleep(DEBUG_DELAY);
                                continue block22;
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                        break block36;
                    }
                    catch (IOException e) {
                        this.logger.severe("I/O error)!: " + e.getMessage());
                        if (this.inputStream != null) {
                            this.inputStream.close();
                        }
                        throw e;
                    }
                }
                finally {
                    try {
                        if (this.outputStream != null) {
                            this.outputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        this.logger.severe("Close error: " + e1.getMessage());
                        throw e1;
                    }
                }
            }
            InputStream sis = null;
            try {
                sis = this.connection.getInputStream();
            }
            catch (IOException ioe) {
                this.logger.severe("Could not get server response stream");
                throw ioe;
            }
            InputStreamReader sisr = new InputStreamReader(sis);
            LineNumberReader slnr = new LineNumberReader(sisr);
            String result = slnr.readLine();
            if (result == null) {
                this.logger.severe("No response string from server!");
                throw new IOException("No OK from storage server !");
            }
            if (!result.equals(STATUS_OK)) {
                String nextLine;
                this.logger.severe("No response string from server! (response follows:)");
                this.logger.severe("Response: " + result);
                while ((nextLine = slnr.readLine()) != null) {
                    this.logger.severe("Response: " + nextLine);
                }
                throw new IOException("No OK from storage server !");
            }
            String uploadIDStr = slnr.readLine();
            if (uploadIDStr != null) {
                try {
                    Long uploadID = null;
                    uploadID = Long.parseLong(uploadIDStr);
                    this.currentStream.setId(uploadID);
                }
                catch (NumberFormatException nfe) {
                    String msg = new String("Could not parse upload ID: " + uploadIDStr);
                    this.logger.severe(msg);
                }
            }
            if (this.connection instanceof HttpURLConnection) {
                String cookie;
                this.responseCode = ((HttpURLConnection)this.connection).getResponseCode();
                this.responseMessage = ((HttpURLConnection)this.connection).getResponseMessage();
                if (this.responseCode >= 400 || this.responseCode < 200) {
                    int newLimit;
                    this.logger.warning("Upload failed: " + this.currentStream);
                    this.logger.warning("HTTP: " + this.responseMessage + ", " + this.responseCode);
                    this.currentStream.setStatus(-1);
                    if (this.responseCode == 413 && (newLimit = this.limit / 2) >= 256) {
                        this.limit = newLimit;
                        this.logger.info("Upload size limit cutted in half; new limit: " + this.limit);
                    }
                    throw new IOException("Part upload failed");
                }
                if (this.acceptCookies && (cookie = ((HttpURLConnection)this.connection).getHeaderField("Set-Cookie")) != null) {
                    this.sessionCookies.add(cookie);
                }
                this.logger.info("HTTP: " + this.responseMessage + ", " + this.responseCode);
            }
        }
        catch (Exception e) {
            this.logger.severe("Cannot upload !: " + e.getMessage());
            throw e;
        }
        finally {
            this.connected = false;
            this.fireDisconnected();
        }
    }

    @Override
    public void run() {
        this.totalUploadedBytes = 0L;
        this.totalStartTimeMs = System.currentTimeMillis();
        do {
            int idleCount = 0;
            this.getNextUpload();
            while (this.currentUpload == null && this.running) {
                this.fireFinished();
                try {
                    Thread.sleep(ON_IDLE_DELAY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++idleCount;
                this.getNextUpload();
                this.totalUploadedBytes = 0L;
                this.totalStartTimeMs = System.currentTimeMillis();
            }
            if (this.currentUpload == null || this.currentStream == null) continue;
            this.synced = false;
            this.startConnect = System.currentTimeMillis();
            try {
                this.upload();
            }
            catch (Exception e) {
                this.calculateLength();
                this.synced = true;
                this.logger.warning("Exception during upload: " + e.getMessage());
                this.logger.warning("Upload failed: " + this.currentStream);
                this.currentStream.incFailedAttemptsCounter();
                if (this.currentStream.getFailedUploadAttempts() >= MAX_UPLOAD_ATTEMPTS) {
                    this.currentStream.setStatus(-2);
                    this.logger.warning("Dropped upload " + this.currentStream + "\nafter " + MAX_UPLOAD_ATTEMPTS + " attempts !");
                } else {
                    this.currentStream.setStatus(-1);
                }
                this.fireStateChanged(this.currentStream);
                if (this.uploadRetryCount > UPLOAD_RETRIES) {
                    this.responseMessage = "Exception: " + e.getMessage();
                    this.fireStateChanged(null);
                    this.running = false;
                    this.logger.warning(this.uploadRetryCount + " failed uploads. Uploadcache will be terminated!");
                    break;
                }
                try {
                    this.logger.info("Upload cache pauses for " + UPLOAD_RETRY_DELAY + " ms.");
                    Thread.sleep(UPLOAD_RETRY_DELAY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.uploadRetryCount;
                continue;
            }
            this.uploadRetryCount = 0;
            ++this.currentStreamIndex;
            if (this.currentStreamIndex == this.currentUpload.length) {
                this.currentStreamIndex = 0;
                this.currentUpload = null;
            }
            this.connectedTimeInMillis += System.currentTimeMillis() - this.startConnect;
            this.totalUploadLength += this.currentStream.getLength();
            this.logger.info("Uploaded: " + this.currentStream);
            this.currentStream.setStatus(3);
            this.calculateLength();
            this.synced = true;
            this.fireStateChanged(this.currentStream);
        } while (this.running);
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
        this.idle = true;
    }

    public boolean isAcceptCookies() {
        return this.acceptCookies;
    }

    @Override
    public void setAcceptCookies(boolean b) {
        this.acceptCookies = b;
    }
}

