/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class JKeyChooser
extends JComboBox {
    public JKeyChooser(int keyCode) {
        this();
        this.setSelectedItemByCode(keyCode);
    }

    public JKeyChooser() {
        Field[] keFields = KeyEvent.class.getFields();
        for (int i = 0; i < keFields.length; ++i) {
            Class<?> type = keFields[i].getType();
            String name = keFields[i].getName();
            if (!type.isPrimitive() || !type.getName().equals("int") || !name.startsWith("VK_")) continue;
            try {
                int code = keFields[i].getInt(null);
                if (code == 16 || code == 17 || code == 18) continue;
                Key k = new Key(code);
                this.addItem(k);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void setSelectedItemByCode(int keyCode) {
        Key k = new Key(keyCode);
        this.setSelectedItem(k);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] ch = this.getComponents();
        for (int i = 0; i < ch.length; ++i) {
            ch[i].setEnabled(enabled);
        }
    }

    public static void main(String[] args) {
        JKeyChooser kc = new JKeyChooser();
        JFrame f = new JFrame("KeyCooser");
        f.getContentPane().add(kc);
        f.pack();
        f.setVisible(true);
    }

    public class Key {
        private int code;

        public Key(int code) {
            this.code = code;
        }

        public String toString() {
            return KeyEvent.getKeyText(this.code);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return k.getCode() == this.code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

