/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.table;

import ipsk.awt.font.AutoFontFamilyManager;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class AutoFontCellRenderer
implements TableCellRenderer {
    private TableCellRenderer defRenderer;
    private AutoFontFamilyManager fontManager = null;

    public String[] getPreferredFontFamilies() {
        return this.fontManager.getPreferredFontFamilies();
    }

    public void setPreferredFontFamilies(String[] preferredFontFamilies) {
        this.fontManager.setPreferredFontFamilies(preferredFontFamilies);
    }

    public boolean isSearchOtherFonts() {
        return this.fontManager.isSearchOtherFonts();
    }

    public void setSearchOtherFonts(boolean searchOtherFonts) {
        this.fontManager.setSearchOtherFonts(searchOtherFonts);
    }

    public List<String> getFontFamilies() {
        return this.fontManager.getFontFamilies();
    }

    public AutoFontCellRenderer(TableCellRenderer defRenderer) {
        this.defRenderer = defRenderer;
        this.fontManager = new AutoFontFamilyManager();
    }

    public AutoFontCellRenderer(TableCellRenderer defRenderer, String[] preferredFontFamilies, boolean searchOtherFonts) {
        this.defRenderer = defRenderer;
        this.fontManager = new AutoFontFamilyManager(preferredFontFamilies, searchOtherFonts);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component defComp = this.defRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (defComp != null && value != null) {
            String valStr = value.toString();
            Font cmpFont = defComp.getFont();
            Font dFont = this.fontManager.getFontCanDisplay(cmpFont, valStr);
            if (dFont != cmpFont) {
                defComp.setFont(dFont);
            }
        }
        return defComp;
    }
}

