/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util;

import java.awt.Window;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;

public class SystemHelper {
    private String osName = System.getProperty("os.name");
    private String javaVersion = System.getProperty("java.version");
    private String javaVendor = System.getProperty("java.vendor");
    private static volatile SystemHelper instance = null;
    private static final String OS_MAC_OS_X_NAME = "Mac OS X";
    private static final String OS_WINDOWS_NAME = "Windows";
    private static final String OS_LINUX_NAME = "Linux";
    private static final String FREE_DESKTOP_DATA_HOME_ENV_VAR_NAME = "XDG_DATA_HOME";
    private static final String FREE_DESKTOP_DATA_HOME_DEFAULT_DIRNAME = ".local/share";
    private static final String FREE_DESKTOP_CONFIG_HOME_ENV_VAR_NAME = "XDG_CONFIG_HOME";
    private static final String FREE_DESKTOP_CONFIG_HOME_DEFAULT_DIRNAME = ".config";
    private static final String MAC_OS_X_LIBRARY_NAME = "Library";
    private static final String MAC_OS_X_APPLICATION_SUPPORT_NAME = "Application Support";
    private static final String WINDOWS_APPLICATION_DATA_ENV_NAME = "AppData";
    private boolean isWindows = false;

    public SystemHelper() {
        Pattern winPattern = Pattern.compile("^Windows.*", 66);
        this.isWindows = winPattern.matcher(this.osName).matches();
    }

    public static synchronized SystemHelper getInstance() {
        if (instance == null) {
            instance = new SystemHelper();
        }
        return instance;
    }

    public boolean isMacOSX() {
        return OS_MAC_OS_X_NAME.equalsIgnoreCase(this.osName);
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isLinux() {
        return OS_LINUX_NAME.equalsIgnoreCase(this.osName);
    }

    public Path homeDirPath() {
        String userHomePropStr = System.getProperty("user.home");
        if (userHomePropStr != null) {
            return Paths.get(userHomePropStr, new String[0]);
        }
        return null;
    }

    public Path applicationUserDataFolder() {
        Path homeDir = this.homeDirPath();
        if (this.isLinux()) {
            String relDataHomePath = System.getenv(FREE_DESKTOP_DATA_HOME_ENV_VAR_NAME);
            if (relDataHomePath == null) {
                relDataHomePath = FREE_DESKTOP_DATA_HOME_DEFAULT_DIRNAME;
            }
            return homeDir.resolve(relDataHomePath);
        }
        if (this.isMacOSX()) {
            Path libraryPath = homeDir.resolve(MAC_OS_X_LIBRARY_NAME);
            Path appSupportPath = libraryPath.resolve(MAC_OS_X_APPLICATION_SUPPORT_NAME);
            return appSupportPath;
        }
        if (this.isWindows()) {
            String appDataStr = System.getenv(WINDOWS_APPLICATION_DATA_ENV_NAME);
            return Paths.get(appDataStr, new String[0]);
        }
        return null;
    }

    public Path applicationUserConfigFolder() {
        if (this.isLinux()) {
            String relCfgHomePath = System.getenv(FREE_DESKTOP_CONFIG_HOME_ENV_VAR_NAME);
            if (relCfgHomePath == null) {
                relCfgHomePath = FREE_DESKTOP_CONFIG_HOME_DEFAULT_DIRNAME;
            }
            Path homeDir = this.homeDirPath();
            return homeDir.resolve(relCfgHomePath);
        }
        return this.applicationUserDataFolder();
    }

    public boolean avoidWindowDispose() {
        return this.isMacOSX();
    }

    public static void disposeWindowForReuse(Window window) {
        SystemHelper sh = SystemHelper.getInstance();
        if (sh.avoidWindowDispose()) {
            window.setVisible(false);
        } else {
            window.dispose();
        }
    }

    public static void main(String[] args) {
        SystemHelper sh = SystemHelper.getInstance();
        System.out.print("Detected operating system: ");
        if (sh.isLinux()) {
            System.out.println(OS_LINUX_NAME);
        } else if (sh.isMacOSX()) {
            System.out.println("Mac OS X ");
        } else if (sh.isWindows()) {
            System.out.println(OS_LINUX_NAME);
        } else {
            System.out.println("(None)");
            System.err.println("Could not determine operating system type!");
        }
        System.out.println("User applicaton data folder: " + sh.applicationUserDataFolder());
        System.out.println("User application config folder: " + sh.applicationUserConfigFolder());
    }
}

