package ipsk.swing;

public class ApplyException extends Exception {
	
	public static final String DEFAULT_TITLE="Error";
	
	private String title=DEFAULT_TITLE;
	public String getTitle() {
		return title;
	}

	public ApplyException(String title,String message) {
		super(message);
		this.title=title;
	}

	public ApplyException(String title,String message, Throwable cause) {
		super(message, cause);
		this.title=title;
	}
	
	public ApplyException(String message) {
		this(DEFAULT_TITLE,message);
	}

	public ApplyException(Throwable cause) {
		this(DEFAULT_TITLE,cause);
	}

	public ApplyException(String message, Throwable cause) {
		this(DEFAULT_TITLE,message,cause);
	}

}
