/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.FramedEditingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CuttingInputStream
extends FramedEditingInputStream {
    private long fromByte;
    private long toByte;
    private long pos;
    private long isPos;
    private byte[] frameBuf;
    private int pushBackLen;

    public CuttingInputStream(InputStream is, long off, long length) {
        this(is, 1, off, length);
    }

    public CuttingInputStream(InputStream is, int frameSize, long off, long length) {
        super(is, frameSize);
        this.fromByte = off * (long)frameSize;
        this.toByte = this.fromByte + length * (long)frameSize;
        this.pos = 0L;
        this.frameBuf = new byte[frameSize];
        this.pushBackLen = 0;
        this.isPos = 0L;
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        if (length % this.frameSize > 0) {
            throw new IOException("bytes to read must be multiple of frame size");
        }
        if (length == 0) {
            return 0;
        }
        int copied = 0;
        long toRead = length;
        if (this.pushBackLen > 0) {
            System.arraycopy(this.frameBuf, 0, buf, offset, this.pushBackLen);
            offset += this.pushBackLen;
            copied += this.pushBackLen;
            this.pos += (long)this.pushBackLen;
            length -= this.pushBackLen;
            toRead -= (long)this.pushBackLen;
            this.pushBackLen = 0;
        }
        if (this.isPos < this.fromByte) {
            int read;
            if (toRead > this.fromByte - this.isPos) {
                toRead = this.fromByte - this.isPos;
            }
            if ((read = this.is.read(buf, offset, (int)toRead)) == -1) {
                return read;
            }
            this.isPos += (long)read;
            this.pushBackLen = (copied + read) % this.frameSize;
            if (this.pushBackLen > 0) {
                System.arraycopy(buf, offset + read - this.pushBackLen, this.frameBuf, 0, this.pushBackLen);
            }
            return copied += read - this.pushBackLen;
        }
        while (this.isPos >= this.fromByte && this.isPos < this.toByte) {
            long toSkip = this.toByte - this.isPos;
            this.isPos += this.is.skip(toSkip);
        }
        if (this.isPos >= this.toByte) {
            int read = this.is.read(buf, offset, (int)toRead);
            if (read == -1) {
                return read;
            }
            this.isPos += (long)read;
            this.pushBackLen = (copied + read) % this.frameSize;
            if (this.pushBackLen > 0) {
                System.arraycopy(buf, offset + read - this.pushBackLen, this.frameBuf, 0, this.pushBackLen);
            }
            return copied += read - this.pushBackLen;
        }
        if (copied == 0) {
            return this.read(buf, offset, length);
        }
        return copied;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n % (long)this.frameSize > 0L) {
            throw new IOException("bytes to skip must be multiple of frame size");
        }
        if (n == 0L) {
            return 0L;
        }
        int skipped = 0;
        long toSkip = n;
        if (this.pushBackLen > 0) {
            skipped += this.pushBackLen;
            this.pos += (long)this.pushBackLen;
            toSkip -= (long)this.pushBackLen;
            this.pushBackLen = 0;
        }
        if (this.isPos < this.fromByte) {
            if (toSkip > this.fromByte - this.isPos) {
                toSkip = this.fromByte - this.isPos;
            }
            do {
                long s = this.is.skip(toSkip);
                skipped = (int)((long)skipped + s);
                this.isPos += s;
            } while (skipped % this.frameSize > 0);
            return skipped;
        }
        if (this.isPos >= this.fromByte && this.isPos < this.toByte) {
            long isToSkip = this.toByte - this.isPos;
            this.isPos += this.is.skip(isToSkip);
        }
        if (this.isPos >= this.toByte) {
            do {
                long s = this.is.skip(toSkip);
                skipped = (int)((long)skipped + s);
                this.isPos += s;
            } while (skipped % this.frameSize > 0);
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        int avail = this.is.available();
        if (this.isPos < this.fromByte) {
            if ((long)avail > this.fromByte - this.isPos) {
                avail = (int)(this.fromByte - this.isPos);
            }
        } else if (this.isPos >= this.fromByte && this.isPos < this.toByte && (avail = (int)((long)avail - (this.toByte - this.isPos))) < 0) {
            avail = 0;
        }
        return avail;
    }
}

