/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.FloatStream;
import ipsk.io.InterleavedFloatStream;
import java.io.IOException;

public class FloatStreamAdapter
implements FloatStream {
    private InterleavedFloatStream srcStream;
    private double[][] monoBuf;
    private int channel;

    public FloatStreamAdapter(InterleavedFloatStream srcStream, int channel) {
        this.srcStream = srcStream;
        this.channel = channel;
        this.monoBuf = new double[0][1];
    }

    @Override
    public int read(double[] buf, int offset, int len) throws IOException {
        int r;
        if (this.monoBuf.length < len) {
            this.monoBuf = new double[len][1];
        }
        if ((r = this.srcStream.read(this.monoBuf, 0, len)) > 0) {
            for (int i = 0; i < r; ++i) {
                buf[offset + i] = this.monoBuf[i][this.channel];
            }
        }
        return r;
    }

    @Override
    public long skip(long skip) throws IOException {
        return this.srcStream.skip(skip);
    }

    @Override
    public void close() throws IOException {
        this.srcStream.close();
    }
}

