/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math.bool;

import ipsk.lang.reflect.NativeTypeWrapper;
import ipsk.math.bool.BoolExpr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class ExtBoolExpr
extends BoolExpr {
    public static final String STARTS_WITH = "(starts with)";
    public static final String ENDS_WITH = "(ends with)";
    public static String CONTAINS = "(contains)";
    public static String EQUALS = "(equals)";
    public static String EQUALS_NOT = "(equals not)";
    public static String MEMBER = "(has member)";
    public static String NOT_MEMBER = "(has no member)";
    public static String BOUND = "(is bound)";
    public static String NOT_BOUND = "(is not bound)";
    private boolean caseInSensitive = false;

    public ExtBoolExpr() {
    }

    public ExtBoolExpr(String col, Object val) {
        this();
        this.operand0 = col;
        this.operand1 = val;
    }

    @Override
    public boolean isExpression() {
        String[] exprOps = ExtBoolExpr.getExprOperators();
        for (int i = 0; i < exprOps.length; ++i) {
            if (!exprOps[i].equals(this.operator)) continue;
            return true;
        }
        return false;
    }

    public ExtBoolExpr addEmptyExpression() throws CloneNotSupportedException {
        ExtBoolExpr newConditon = new ExtBoolExpr();
        newConditon.setOperator(AND);
        newConditon.setOperand0(this);
        newConditon.setOperand1(new ExtBoolExpr());
        return newConditon;
    }

    public static String[] getNumberExprOperators() {
        return BoolExpr.getExprOperators();
    }

    public static String[] getExprOperators() {
        ArrayList<String> ops = new ArrayList<String>();
        ops.addAll(Arrays.asList(BoolExpr.getExprOperators()));
        String[] addOps = new String[]{STARTS_WITH, ENDS_WITH, CONTAINS, EQUALS, EQUALS_NOT, MEMBER, NOT_MEMBER, BOUND, NOT_BOUND};
        ops.addAll(Arrays.asList(addOps));
        return ops.toArray(new String[0]);
    }

    public static String[] getExprOperatorsWithoutRelationshipOperators() {
        ArrayList<String> ops = new ArrayList<String>();
        ops.addAll(Arrays.asList(BoolExpr.getExprOperators()));
        String[] addOps = new String[]{STARTS_WITH, ENDS_WITH, CONTAINS};
        ops.addAll(Arrays.asList(addOps));
        return ops.toArray(new String[0]);
    }

    public boolean unaryOperator() {
        return BOUND.equals(this.operator) || NOT_BOUND.equals(this.operator);
    }

    public static boolean isOperatorSupportingType(Object operator, Class<?> type) {
        Class<?> wrapType = NativeTypeWrapper.getWrapperClass(type);
        if (wrapType.equals(Boolean.class)) {
            return operator.equals(EQUAL) || operator.equals(NOT_EQUAL);
        }
        if (wrapType.isEnum()) {
            return operator.equals(EQUAL) || operator.equals(NOT_EQUAL);
        }
        if (wrapType.equals(String.class)) {
            return operator.equals(">=") || operator.equals(">") || operator.equals("<=") || operator.equals("<") || operator.equals(EQUAL) || operator.equals(NOT_EQUAL) || operator.equals(STARTS_WITH) || operator.equals(ENDS_WITH) || operator.equals(CONTAINS);
        }
        if (wrapType.equals(Character.class)) {
            return operator.equals(">=") || operator.equals(">") || operator.equals("<=") || operator.equals("<") || operator.equals(EQUAL) || operator.equals(NOT_EQUAL);
        }
        if (Number.class.isAssignableFrom(wrapType)) {
            return operator.equals(EQUAL) || operator.equals(NOT_EQUAL) || operator.equals(">=") || operator.equals(">") || operator.equals("<=") || operator.equals("<");
        }
        if (Date.class.isAssignableFrom(wrapType)) {
            return operator.equals(EQUAL) || operator.equals(NOT_EQUAL) || operator.equals(">=") || operator.equals(">") || operator.equals("<=") || operator.equals("<");
        }
        return operator.equals(MEMBER) || operator.equals(NOT_MEMBER) || operator.equals(EQUALS) || operator.equals(EQUALS_NOT);
    }

    public boolean isObjectRelationShip() {
        return this.operator != null && (this.operator.equals(EQUALS) || this.operator.equals(MEMBER) || this.operator.equals(EQUALS_NOT) || this.operator.equals(NOT_MEMBER) || this.operator.equals(BOUND) || this.operator.equals(NOT_BOUND));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ExtBoolExpr clone = new ExtBoolExpr();
        if (this.operand0 != null && this.operand0 instanceof ExtBoolExpr) {
            clone.setOperand0(((ExtBoolExpr)this.operand0).clone());
        } else {
            clone.setOperand0(this.cloneType(this.operand0));
        }
        clone.setOperator(this.cloneType(this.operator));
        if (this.operand1 != null && this.operand1 instanceof ExtBoolExpr) {
            clone.setOperand1(((ExtBoolExpr)this.operand1).clone());
        } else {
            clone.setOperand1(this.cloneType(this.operand1));
        }
        clone.setCaseInSensitive(this.caseInSensitive);
        return clone;
    }

    public boolean isCaseInSensitive() {
        return this.caseInSensitive;
    }

    public void setCaseInSensitive(boolean caseInSensitive) {
        this.caseInSensitive = caseInSensitive;
    }
}

