/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.text;

import ipsk.swing.text.EditorKitMenu;
import ipsk.swing.text.LinePosition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;

public class JTextPaneEditor
extends JPanel
implements CaretListener {
    protected JTextPane textPane;
    protected JPanel positionPanel;
    protected JLabel positionLabel;
    protected String text;
    private Pattern newLinePattern = Pattern.compile("\r\n|\r|\n");

    public JTextPaneEditor() {
        super(new BorderLayout());
        this.textPane = new JTextPane();
        EditorKitMenu textPaneEkm = new EditorKitMenu(this.textPane);
        textPaneEkm.setPopupMenuActiv(true);
        this.textPane.addCaretListener(this);
        this.positionPanel = new JPanel(new FlowLayout(4));
        this.positionLabel = new JLabel("-:-");
        this.positionPanel.add(this.positionLabel);
        this.add((Component)new JScrollPane(this.textPane), "Center");
        this.add((Component)this.positionPanel, "South");
    }

    public void setText(String text) {
        this.textPane.setText(text);
    }

    public String getText() {
        return this.textPane.getText();
    }

    protected LinePosition convertToLinePosition(int pos) {
        LinePosition p = new LinePosition(1, 1);
        int c = 0;
        String t = this.textPane.getText();
        Matcher m = this.newLinePattern.matcher(t);
        int ll = 0;
        int mc = 0;
        do {
            if (!m.find()) {
                p.col = pos - c + 1;
                break;
            }
            ll = m.start() - mc + 1;
            mc = m.end();
            if (c + ll > pos) {
                p.col = pos - c + 1;
                break;
            }
            ++p.line;
        } while ((c += ll) < pos);
        return p;
    }

    public static void main(String[] args) {
        JTextPaneEditor textPaneEditor = null;
        textPaneEditor = new JTextPaneEditor();
        JFrame f = new JFrame();
        f.getContentPane().add(textPaneEditor);
        f.pack();
        f.setVisible(true);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int pos = e.getDot();
        LinePosition lp = this.convertToLinePosition(pos);
        this.positionLabel.setText(lp.toString());
    }

    public Document getDocument() {
        return this.textPane.getDocument();
    }
}

