/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class NaturalNumberFormat
extends NumberFormat {
    private int digitCount;
    private long MIN_VALUE = 0L;
    private long maxValue = 0L;

    public NaturalNumberFormat(int digitCount) {
        BigInteger maxLongValue;
        this.digitCount = digitCount;
        if (digitCount < 0) {
            throw new IllegalArgumentException("Digit count must be greater than 0");
        }
        BigInteger maxValueBi = BigInteger.TEN.pow(digitCount);
        int cmp = maxValueBi.compareTo(maxLongValue = BigInteger.valueOf(Long.MAX_VALUE));
        if (cmp > 0) {
            throw new IllegalArgumentException("Digit count exponent exceeds max value of native type long");
        }
        this.maxValue = maxValueBi.longValue() - 1L;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        double flooredNumber;
        boolean infiniteOrNaN;
        boolean bl = infiniteOrNaN = Double.isInfinite(number) || Double.isNaN(number);
        if (!infiniteOrNaN && (flooredNumber = Math.floor(number)) == number) {
            long longNumber = (long)flooredNumber;
            return this.format(longNumber, toAppendTo, pos);
        }
        return null;
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number >= this.MIN_VALUE && number <= this.maxValue) {
            String longStr = Long.toString(number);
            int leadingZeroCnt = this.digitCount - longStr.length();
            for (int i = 0; i < leadingZeroCnt; ++i) {
                toAppendTo.append('0');
            }
            toAppendTo.append(longStr);
        }
        return toAppendTo;
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        Long val = null;
        int pp = parsePosition.getIndex();
        int sourceLength = source.length();
        if (sourceLength == this.digitCount) {
            int exponent = 1;
            long lVal = 0L;
            for (int i = pp + sourceLength - 1; i >= pp; --i) {
                char ch = source.charAt(i);
                if (!Character.isDigit(ch)) {
                    parsePosition.setIndex(pp + i);
                    parsePosition.setErrorIndex(pp + i);
                    return null;
                }
                int digit = Character.digit(ch, 10);
                lVal += (long)(digit * exponent);
                exponent *= 10;
            }
            parsePosition.setIndex(pp + this.digitCount);
            val = lVal;
        } else {
            int relErrIdx = sourceLength;
            if (relErrIdx > this.digitCount) {
                relErrIdx = this.digitCount;
            }
            parsePosition.setErrorIndex(parsePosition.getIndex() + relErrIdx);
        }
        return val;
    }
}

