/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import ipsk.text.ParserException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class StringObjectConverter {
    public static Object stringToObject(String strValue, Class<?> propertyType, Locale locale) throws ParserException {
        if (locale == null) {
            return StringObjectConverter.stringToObject(strValue, propertyType);
        }
        if (Date.class.isAssignableFrom(propertyType)) {
            try {
                return DateFormat.getDateTimeInstance(2, 2, locale).parse(strValue);
            }
            catch (ParseException e) {
                throw new ParserException(e);
            }
        }
        return StringObjectConverter.stringToObject(strValue, propertyType);
    }

    public static Object stringToObject(String strValue, Class<?> propertyType) throws ParserException {
        try {
            if (propertyType.equals(Character.TYPE) || propertyType.equals(Character.class)) {
                if (strValue.length() != 1) {
                    throw new ParserException("Cannot parse to single character!");
                }
                return new Character(strValue.charAt(0));
            }
            if (propertyType.equals(Integer.TYPE) || propertyType.equals(Integer.class)) {
                return new Integer(strValue);
            }
            if (propertyType.equals(Float.TYPE) || propertyType.equals(Float.class)) {
                return new Float(strValue);
            }
            if (propertyType.equals(Double.TYPE) || propertyType.equals(Double.class)) {
                return new Double(strValue);
            }
            if (propertyType.equals(Long.TYPE) || propertyType.equals(Long.class)) {
                return new Long(strValue);
            }
            if (propertyType.equals(Short.TYPE) || propertyType.equals(Short.class)) {
                return new Long(strValue);
            }
            if (propertyType.equals(Boolean.TYPE) || propertyType.equals(Boolean.class)) {
                return new Boolean(strValue);
            }
            if (propertyType.equals(String.class)) {
                return strValue;
            }
            if (Date.class.isAssignableFrom(propertyType)) {
                try {
                    return DateFormat.getDateTimeInstance().parse(strValue);
                }
                catch (ParseException e) {
                    throw new ParserException(e);
                }
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(nfe);
        }
    }
}

