/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.collections;

import ipsk.util.collections.BasicCollectionObserver;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ObservableList<E>
extends BasicCollectionObserver<E>
implements List<E> {
    protected List<E> list;

    public ObservableList(List<E> list) {
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean changed = this.list.add(e);
        if (changed) {
            this.fireCollectionChangedEvent();
        }
        return changed;
    }

    @Override
    public boolean remove(Object o) {
        boolean changed = this.list.remove(o);
        if (changed) {
            this.fireCollectionChangedEvent();
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = this.list.addAll(c);
        if (changed) {
            this.fireCollectionChangedEvent();
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = this.list.removeAll(c);
        if (changed) {
            this.fireCollectionChangedEvent();
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = this.list.retainAll(c);
        if (changed) {
            this.fireCollectionChangedEvent();
        }
        return changed;
    }

    @Override
    public void clear() {
        boolean changed = !this.list.isEmpty();
        this.list.clear();
        if (changed) {
            this.fireCollectionChangedEvent();
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        E s = this.list.set(index, element);
        this.fireCollectionChangedEvent();
        return s;
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
        this.fireCollectionChangedEvent();
    }

    @Override
    public E remove(int index) {
        E r = this.list.remove(index);
        this.fireCollectionChangedEvent();
        return r;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }
}

