/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.IOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class InterceptorInputStream
extends InputStream {
    private Vector<IOutputStream> outputStreams = new Vector();
    private InputStream srcInputStream;
    private boolean outputStreamsClosed = false;
    private byte[] oneByteBuffer = new byte[1];

    public InterceptorInputStream(InputStream srcInputStream) {
        this.srcInputStream = srcInputStream;
    }

    @Override
    public int read() throws IOException {
        int sr = this.srcInputStream.read();
        if (sr == -1) {
            this.closeOutputStreams();
            return -1;
        }
        this.writeToOutputStreams(sr);
        return sr;
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        int sr = this.srcInputStream.read(buf, offset, len);
        if (sr == -1) {
            this.closeOutputStreams();
            return -1;
        }
        this.writeToOutputStreams(buf, offset, len);
        return sr;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        int sr = this.srcInputStream.read(buf);
        if (sr == -1) {
            this.closeOutputStreams();
            return -1;
        }
        this.writeToOutputStreams(buf, 0, sr);
        return sr;
    }

    @Override
    public void close() throws IOException {
        this.closeOutputStreams();
        this.srcInputStream.close();
    }

    private void writeToOutputStreams(int b) throws IOException {
        for (IOutputStream os : this.outputStreams) {
            this.oneByteBuffer[0] = (byte)(0xFF & b);
            os.write(this.oneByteBuffer, 0, 1);
        }
    }

    private void writeToOutputStreams(byte[] buf, int offset, int len) throws IOException {
        for (IOutputStream os : this.outputStreams) {
            os.write(buf, offset, len);
        }
    }

    private void closeOutputStreams() throws IOException {
        if (!this.outputStreamsClosed) {
            for (IOutputStream os : this.outputStreams) {
                os.close();
            }
            this.outputStreamsClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputStream(IOutputStream os) {
        Vector<IOutputStream> vector = this.outputStreams;
        synchronized (vector) {
            if (os != null && !this.outputStreams.contains(os)) {
                this.outputStreams.addElement(os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputStream(IOutputStream os) {
        Vector<IOutputStream> vector = this.outputStreams;
        synchronized (vector) {
            if (os != null) {
                this.outputStreams.removeElement(os);
            }
        }
    }
}

