/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.text;

import ipsk.swing.EnumSelectionItem;
import ipsk.swing.EnumVector;
import ipsk.text.TableTextFormat;
import ipsk.text.TableTextFormats;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TableFormatSelector
extends JPanel
implements ActionListener {
    private static EnumVector<TableTextFormats.Profile> PROFILE = new EnumVector<TableTextFormats.Profile>(TableTextFormats.Profile.class, "<Custom>");
    private JComboBox profileBox;
    private static EnumVector<TableTextFormats.UnitSeparator> UNIT_SEPARATORS = new EnumVector<TableTextFormats.UnitSeparator>(TableTextFormats.UnitSeparator.class);
    private JComboBox unitSepBox;
    private static EnumVector<TableTextFormats.RecordSeparator> RECORD_SEPARATORS = new EnumVector<TableTextFormats.RecordSeparator>(TableTextFormats.RecordSeparator.class);
    private JComboBox recordSepBox;
    private static EnumVector<TableTextFormats.GroupSeparator> GROUP_SEPARATORS = new EnumVector<TableTextFormats.GroupSeparator>(TableTextFormats.GroupSeparator.class);
    private JComboBox groupSepBox;
    private boolean adjusting = false;

    public TableFormatSelector() {
        super(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.gridx = 0;
        this.add((Component)new JLabel("Profile:"), gbc);
        ++gbc.gridx;
        this.profileBox = new JComboBox<TableTextFormats.Profile>(PROFILE);
        this.add((Component)this.profileBox, gbc);
        this.profileBox.addActionListener(this);
        gbc.gridx = 0;
        this.add((Component)new JLabel("Field sep.:"), gbc);
        ++gbc.gridx;
        this.unitSepBox = new JComboBox<TableTextFormats.UnitSeparator>(UNIT_SEPARATORS);
        this.unitSepBox.addActionListener(this);
        this.add((Component)this.unitSepBox, gbc);
        gbc.gridx = 0;
        this.add((Component)new JLabel("Record sep.:"), gbc);
        ++gbc.gridx;
        this.recordSepBox = new JComboBox<TableTextFormats.RecordSeparator>(RECORD_SEPARATORS);
        this.recordSepBox.addActionListener(this);
        this.add((Component)this.recordSepBox, gbc);
        gbc.gridx = 0;
        this.add((Component)new JLabel("Group sep."), gbc);
        ++gbc.gridx;
        this.groupSepBox = new JComboBox<TableTextFormats.GroupSeparator>(GROUP_SEPARATORS);
        this.add((Component)this.groupSepBox, gbc);
        this.groupSepBox.addActionListener(this);
        this.setSelectedProfile(TableTextFormats.Profile.ASCII_UNICODE);
    }

    public static void main(String[] args) {
        final TableFormatSelector tfs = new TableFormatSelector();
        Runnable show = new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                f.setDefaultCloseOperation(3);
                f.getContentPane().add(tfs);
                f.pack();
                f.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(show);
    }

    public TableTextFormat getFormat() {
        TableTextFormat format = new TableTextFormat(this.getGroupSeparator().value(), this.getRecordSeparator().value(), new char[]{this.getUnitSeparator().value()});
        return format;
    }

    public TableTextFormats.UnitSeparator getUnitSeparator() {
        EnumSelectionItem selIt = (EnumSelectionItem)this.unitSepBox.getSelectedItem();
        return (TableTextFormats.UnitSeparator)((Object)selIt.getEnumVal());
    }

    public TableTextFormats.RecordSeparator getRecordSeparator() {
        EnumSelectionItem selIt = (EnumSelectionItem)this.recordSepBox.getSelectedItem();
        return (TableTextFormats.RecordSeparator)((Object)selIt.getEnumVal());
    }

    public TableTextFormats.GroupSeparator getGroupSeparator() {
        EnumSelectionItem selIt = (EnumSelectionItem)this.groupSepBox.getSelectedItem();
        return (TableTextFormats.GroupSeparator)((Object)selIt.getEnumVal());
    }

    private void applySelectedProfile() {
        if (this.adjusting) {
            return;
        }
        EnumSelectionItem selProfIt = (EnumSelectionItem)this.profileBox.getSelectedItem();
        TableTextFormats.Profile selProf = (TableTextFormats.Profile)((Object)selProfIt.getEnumVal());
        this.applyProfile(selProf);
    }

    private void applyProfile(TableTextFormats.Profile selProf) {
        if (selProf != null) {
            this.unitSepBox.setSelectedItem(UNIT_SEPARATORS.getItem(selProf.getFieldSeparator()));
            this.recordSepBox.setSelectedItem(RECORD_SEPARATORS.getItem(selProf.getRecordSeparator()));
            this.groupSepBox.setSelectedItem(GROUP_SEPARATORS.getItem(selProf.getGroupSeparator()));
        }
    }

    private void updateProfile() {
        TableTextFormats.Profile matchProf = TableTextFormats.matchesProfile(this.getUnitSeparator(), this.getRecordSeparator(), this.getGroupSeparator());
        EnumSelectionItem<TableTextFormats.Profile> matchProfSi = new EnumSelectionItem<TableTextFormats.Profile>(matchProf);
        this.profileBox.setSelectedItem(matchProfSi);
    }

    public void setSelectedProfile(TableTextFormats.Profile profile) {
        this.profileBox.setSelectedItem(new EnumSelectionItem<TableTextFormats.Profile>(profile));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        if (src == this.profileBox) {
            this.applySelectedProfile();
        } else {
            this.adjusting = true;
            this.updateProfile();
        }
        this.adjusting = false;
    }
}

