/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import ipsk.text.ParserException;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class Version
implements Comparable<Version> {
    private int[] version;

    public Version(int[] version) {
        this.version = version;
    }

    public static Version parseString(String versionString) throws ParserException {
        String[] numberStrs = versionString.split("[.]");
        if (numberStrs == null || numberStrs.length == 0) {
            throw new ParserException("Could not parse version string");
        }
        int[] vns = new int[numberStrs.length];
        for (int i = 0; i < numberStrs.length; ++i) {
            try {
                int vn;
                vns[i] = vn = Integer.parseInt(numberStrs[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new ParserException(nfe);
            }
        }
        Version v = new Version(vns);
        return v;
    }

    @Override
    public int compareTo(Version otherVersion) {
        int i;
        int[] ovs = otherVersion.getVersion();
        int c = 0;
        for (i = 0; i < this.version.length; ++i) {
            Integer vi = new Integer(this.version[i]);
            if (i >= ovs.length) {
                if (vi <= 0) continue;
                return 1;
            }
            c = vi.compareTo(ovs[i]);
            if (c == 0) continue;
            return c;
        }
        if (this.version.length < ovs.length) {
            for (i = this.version.length; i < ovs.length; ++i) {
                if (ovs[i] <= 0) continue;
                return -1;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.version != null && this.version.length > 0) {
            for (int i = 0; i < this.version.length - 1; ++i) {
                sb.append(this.version[i]);
                sb.append(".");
            }
            sb.append(this.version[this.version.length - 1]);
        }
        return sb.toString();
    }

    public int[] getVersion() {
        return this.version;
    }

    public static class VersionXMLAdapter
    extends XmlAdapter<String, Version> {
        public String marshal(Version v) throws Exception {
            return v.toString();
        }

        public Version unmarshal(String v) throws Exception {
            return Version.parseString(v);
        }
    }
}

