/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.services;

import ipsk.text.ParserException;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.ServiceDescriptor;
import java.net.URL;
import java.util.jar.Attributes;

public class PackageServiceDescriptor<D extends ServiceDescriptor, S>
implements ServiceDescriptor {
    private URL packageURL;
    private Class<S> serviceClass;
    private String serviceImplementationClassname;
    private Package p;
    private Attributes mainAttributes;
    private LocalizableMessage title = null;
    private Version specVersion = null;
    private Version implementationVersion = null;

    public PackageServiceDescriptor(Class<S> serviceClass, String serviceImplementationClassname, Package p) {
        this.serviceClass = serviceClass;
        this.serviceImplementationClassname = serviceImplementationClassname;
        this.p = p;
        if (p != null) {
            String titleStr = p.getImplementationTitle();
            if (titleStr != null) {
                this.title = new LocalizableMessage(titleStr);
            }
            String specVersStr = p.getSpecificationVersion();
            try {
                this.specVersion = Version.parseString(specVersStr);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
            String implVersStr = p.getImplementationVersion();
            try {
                this.implementationVersion = Version.parseString(implVersStr);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
    }

    private String getMainAttribute(Attributes.Name key) {
        Object value;
        if (this.mainAttributes != null && (value = this.mainAttributes.get(key)) != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private LocalizableMessage getMainAttributeAsLocalizableMessage(Attributes.Name key) {
        Object value;
        if (this.mainAttributes != null && (value = this.mainAttributes.get(key)) != null && value instanceof String) {
            return new LocalizableMessage((String)value);
        }
        return null;
    }

    private Version getMainAttributeAsVersion(Attributes.Name key) {
        String versStr;
        if (this.mainAttributes != null && (versStr = this.getMainAttribute(key)) != null) {
            try {
                return Version.parseString(versStr);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public LocalizableMessage getTitle() {
        return this.title;
    }

    @Override
    public LocalizableMessage getDescription() {
        return null;
    }

    @Override
    public String getVendor() {
        return this.p.getImplementationVendor();
    }

    @Override
    public Version getSpecificationVersion() {
        return this.specVersion;
    }

    @Override
    public Version getImplementationVersion() {
        return this.implementationVersion;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public String getServiceImplementationClassname() {
        return this.serviceImplementationClassname;
    }

    public URL getPackageURL() {
        return this.packageURL;
    }

    public void setPackageURL(URL packageURL) {
        this.packageURL = packageURL;
    }
}

