//    Speechrecorder
//    (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

/*
 * Date  : Sep 17, 2007
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */

package ipsk.swing.legal;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import ipsk.swing.JDialogPanel;

/**
 * Dialog for privacy confirmations.
 * 
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 * 
 */

public class JConsentDialog extends JDialogPanel {

   
    private JTextField title;
    private JTextArea textArea;

    public JConsentDialog() {
        super(JDialogPanel.Options.OK_CANCEL);
        ResourceBundle rb=ResourceBundle.getBundle("ipsk.util.Messages");
        String accLoc=rb.getString("accept");
        String declLoc=rb.getString("decline");
        getContentPane().setLayout(new GridBagLayout());
        okButton.setText(accLoc);
        cancelButton.setText(declLoc);
        GridBagConstraints lc=new GridBagConstraints();
        lc.insets = new Insets(2, 2, 2, 2);
        lc.gridx=0;
        lc.gridy=0;
        lc.fill=GridBagConstraints.HORIZONTAL;
        title=new JTextField();
        title.setFont(getFont().deriveFont(Font.BOLD));
        title.setText("Privacy consent");
        
        getContentPane().add(title,lc);
        textArea=new JTextArea();
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        //textArea.setPreferredSize(new Dimension(400,600));
        lc.gridy++;
        JScrollPane sp=new JScrollPane(textArea);
        sp.setPreferredSize(new Dimension(400, 300));
        lc.fill=GridBagConstraints.BOTH;
        lc.weightx=2.0;
        lc.weighty=2.0;
        getContentPane().add(sp,lc);
        revalidate();
        repaint();
    }
    
    public void setTitleText(String titleText){
        title.setText(titleText);
    }
    
    public String getTitleText(){
        return title.getText();
    }
    
    public void setText(String text){
        textArea.setText(text);
        
    }
    
    public String getText(){
        return textArea.getText();
    }

   
}
