/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.FramedEditingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InsertInputStream
extends FramedEditingInputStream {
    private byte[] frameBuf;
    private long bytePos;
    private InputStream insert;
    private long byteAt;
    private boolean insertEnd;
    private static int DEF_PREFERRED_BUF_SIZE = 2048;
    private int bufSize;
    private byte[] skipBuf;
    private int pushBackLen;

    public InsertInputStream(InputStream is, InputStream insert, long at) {
        this(is, insert, 1, at);
    }

    public InsertInputStream(InputStream is, InputStream insert, int frameSize, long at) {
        super(is, frameSize);
        this.insert = insert;
        this.bytePos = 0L;
        this.byteAt = at * (long)frameSize;
        this.frameBuf = new byte[frameSize];
        int bufSizeFrames = DEF_PREFERRED_BUF_SIZE / frameSize;
        this.bufSize = bufSizeFrames * frameSize;
        if (this.bufSize < frameSize) {
            this.bufSize = frameSize;
        }
        this.skipBuf = new byte[frameSize];
        this.insertEnd = false;
        this.pushBackLen = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("read() method is only allowed if frame size equals 1");
        }
        byte[] buf = new byte[1];
        int read = this.read(buf, 0, 1);
        if (read == -1) {
            return read;
        }
        return 0xFF & buf[0];
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        if (len % this.frameSize > 0) {
            throw new IOException("bytes to read must be multiple of frame size");
        }
        long toRead = len;
        int copied = 0;
        if (this.pushBackLen > 0) {
            System.arraycopy(this.frameBuf, 0, buf, offset, this.pushBackLen);
            offset += this.pushBackLen;
            copied += this.pushBackLen;
            this.bytePos += (long)this.pushBackLen;
            len -= this.pushBackLen;
            toRead -= (long)this.pushBackLen;
            this.pushBackLen = 0;
        }
        int read = 0;
        if (this.bytePos < this.byteAt || this.insertEnd) {
            if (!this.insertEnd && toRead > this.byteAt - this.bytePos) {
                toRead = this.byteAt - this.bytePos;
            }
            if ((read = this.is.read(buf, offset, (int)toRead)) == -1) {
                if (copied > 0) {
                    throw new IOException("stream length is not mutiple of frame size");
                }
                return -1;
            }
            copied += read;
        } else {
            read = this.insert.read(buf, offset, (int)toRead);
            if (read == -1) {
                if (copied > 0) {
                    throw new IOException("stream length is not mutiple of frame size");
                }
                this.insertEnd = true;
                this.insert.close();
                read = 0;
            }
            copied += read;
        }
        this.pushBackLen = copied % this.frameSize;
        if (this.pushBackLen > 0) {
            System.arraycopy(buf, read - this.pushBackLen, this.frameBuf, 0, this.pushBackLen);
            copied -= this.pushBackLen;
        }
        this.bytePos += (long)copied;
        if (copied == 0) {
            return this.read(buf, offset, len);
        }
        return copied;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n % (long)this.frameSize > 0L || n < 0L) {
            throw new IOException("bytes to skip must be multiple of frame size");
        }
        long toSkip = n;
        long totalSkipped = 0L;
        if (toSkip == 0L) {
            return 0L;
        }
        toSkip -= (long)this.pushBackLen;
        totalSkipped += (long)this.pushBackLen;
        this.bytePos += (long)this.pushBackLen;
        this.pushBackLen = 0;
        if (this.bytePos < this.byteAt || this.insertEnd) {
            if (!this.insertEnd && toSkip > this.byteAt - this.bytePos) {
                toSkip = this.byteAt - this.bytePos;
            }
            do {
                long skipped = this.is.skip(toSkip);
                toSkip -= skipped;
                totalSkipped += skipped;
                this.bytePos += skipped;
            } while (this.bytePos % (long)this.frameSize > 0L);
            return totalSkipped;
        }
        do {
            long skipped = this.insert.skip(toSkip);
            toSkip -= skipped;
            totalSkipped += skipped;
            this.bytePos += skipped;
        } while (this.bytePos % (long)this.frameSize > 0L);
        if (totalSkipped == 0L) {
            int read = this.insert.read(this.skipBuf);
            if (read == -1) {
                this.insertEnd = true;
                read = 0;
            }
            this.pushBackLen = read % this.frameSize;
            if (this.pushBackLen > 0) {
                System.arraycopy(this.skipBuf, 0, this.frameBuf, 0, this.pushBackLen);
            } else {
                totalSkipped += (long)read;
                this.bytePos += (long)read;
            }
        }
        return totalSkipped;
    }

    @Override
    public int available() throws IOException {
        long isAvailable;
        long maxAvailable;
        int available = 0;
        available = this.insertEnd ? this.is.available() : (this.bytePos < this.byteAt ? ((maxAvailable = this.byteAt - this.bytePos) > (isAvailable = (long)this.is.available()) ? (int)isAvailable : (int)maxAvailable) : this.insert.available());
        return available + this.pushBackLen;
    }

    @Override
    public void close() throws IOException {
        this.insert.close();
        super.close();
    }
}

