/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EditableURL {
    private URL url;

    public EditableURL(URL url) {
        this.url = url;
    }

    public void addQuerys(Hashtable<String, String> queries) throws UnsupportedEncodingException {
        String query = this.url.getQuery();
        if (query == null) {
            query = new String();
        }
        Set<Map.Entry<String, String>> s = queries.entrySet();
        Iterator<Map.Entry<String, String>> it = s.iterator();
        if (!query.equals("") && it.hasNext()) {
            query = query.concat("&");
        }
        while (it.hasNext()) {
            Map.Entry<String, String> me = it.next();
            query = query.concat(URLEncoder.encode(me.getKey(), "UTF-8") + "=" + URLEncoder.encode(me.getValue(), "UTF-8"));
            if (!it.hasNext()) continue;
            query = query.concat("&");
        }
        String urlStr = new String(this.url.getProtocol() + "://" + this.url.getAuthority() + this.url.getPath());
        if (query != null && !query.equals("")) {
            urlStr = urlStr.concat("?" + query);
        }
        if (this.url.getRef() != null && !this.url.getRef().equals("")) {
            urlStr = urlStr.concat("#" + this.url.getRef());
        }
        URL queryUrl = null;
        try {
            queryUrl = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("", e);
        }
        this.url = queryUrl;
    }

    public void addParameterMap(Map<String, String[]> queries) throws UnsupportedEncodingException {
        String query = this.url.getQuery();
        if (query == null) {
            query = new String();
        }
        Set<Map.Entry<String, String[]>> s = queries.entrySet();
        Iterator<Map.Entry<String, String[]>> it = s.iterator();
        if (!query.equals("") && it.hasNext()) {
            query = query.concat("&");
        }
        while (it.hasNext()) {
            String[] vals;
            Map.Entry<String, String[]> me = it.next();
            for (String val : vals = me.getValue()) {
                query = query.concat(URLEncoder.encode(me.getKey(), "UTF-8") + "=" + URLEncoder.encode(val, "UTF-8"));
                if (!it.hasNext()) continue;
                query = query.concat("&");
            }
        }
        String urlStr = new String(this.url.getProtocol() + "://" + this.url.getAuthority() + this.url.getPath());
        if (query != null && !query.equals("")) {
            urlStr = urlStr.concat("?" + query);
        }
        if (this.url.getRef() != null && !this.url.getRef().equals("")) {
            urlStr = urlStr.concat("#" + this.url.getRef());
        }
        URL queryUrl = null;
        try {
            queryUrl = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("", e);
        }
        this.url = queryUrl;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public static void main(String[] args) {
        EditableURL editUrl = null;
        Hashtable<String, String> vals = new Hashtable<String, String>();
        vals.put("key2", "val2");
        try {
            editUrl = new EditableURL(new URL("http://www/test.pl?key1=val1"));
            editUrl.addQuerys(vals);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println(editUrl.getUrl().toExternalForm());
    }
}

