/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import java.io.IOException;
import java.io.InputStream;

public class SkipWorkaroundInputStream
extends InputStream {
    private static final int DEF_DUMMY_BUFSIZE = 2048;
    private InputStream src;
    private int dummyBufsize;
    private byte[] dummyBuf;

    public SkipWorkaroundInputStream(InputStream src) {
        this(src, 2048);
    }

    public SkipWorkaroundInputStream(InputStream src, int dummyBufsize) {
        this.src = src;
        this.dummyBufsize = dummyBufsize;
        this.dummyBuf = new byte[dummyBufsize];
    }

    @Override
    public int read() throws IOException {
        return this.src.read();
    }

    @Override
    public long skip(long n) throws IOException {
        long toSkip = n;
        if (n > (long)this.dummyBufsize) {
            toSkip = this.dummyBufsize;
        }
        return this.src.read(this.dummyBuf, 0, (int)toSkip);
    }

    @Override
    public int available() throws IOException {
        return this.src.available();
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    @Override
    public void mark(int arg0) {
        this.src.mark(arg0);
    }

    @Override
    public boolean markSupported() {
        return this.src.markSupported();
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        return this.src.read(arg0, arg1, arg2);
    }

    @Override
    public int read(byte[] arg0) throws IOException {
        return this.src.read(arg0);
    }

    @Override
    public void reset() throws IOException {
        this.src.reset();
    }

    public String toString() {
        return "Workaround for bad skip() implementations. Source stream: " + this.src.toString();
    }
}

