//    IPS Java Utils
// 	  (c) Copyright 2019
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.lang;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author klaus
 *
 */
public class CollectionUtils<T> {

	public boolean isCombinationOf(List<T> list1,List<T> list2){
		int listSize=list1.size();

		if(listSize==list2.size()) {

			for(int i1=0;i1<listSize;i1++) {
				T o1i=list1.get(i1);
				for(int i2=0;i2<listSize;i2++) {
					T o2i=list2.get(i2);
					if(o1i.equals(o2i)) {
					
						if(listSize==1) {
							return true;
						}else {
							// create arrays with remaining elements ...
							ArrayList<T> rest1=new ArrayList<T>();
							ArrayList<T> rest2=new ArrayList<T>();

							for(int j1=0;j1<listSize;j1++) {
								if(j1!=i1) {
									rest1.add(list1.get(j1));
								}
							}
							for(int j2=0;j2<listSize;j2++) {
								if(j2!=i2) {
									rest2.add(list2.get(j2));
								}
							}
							// ...to proceed recursively
							return isCombinationOf(rest1,rest2);

						}
					}

				}
			}	
		}
		return false;
	}
	
	public Set<T> residualNextMatchingElements(Set<List<T>> possibleListsToMatch,List<T> currentList){
		HashSet<T> possibleEls=new HashSet<>();
		int currentListSize=currentList.size();
		for(List<T> listToMatch:possibleListsToMatch) {
			if(listToMatch.size()>=currentListSize) {
				possibleEls.addAll(residualNextElements(listToMatch, currentList));
			}
		}
		return possibleEls;
	}
	
	public Set<T> residualNextElements(List<T> listToMatch,List<T> currentList){
		int listTomatchSize=listToMatch.size();
		int currentlistSize=currentList.size();
		if(listTomatchSize<currentlistSize) {
			throw new IllegalArgumentException("Size of list to match must be greater than size of current list!");
		}
		HashSet<T> possibleNextset=new HashSet<>();
		if(currentlistSize==0) {
			possibleNextset.addAll(listToMatch);
		}
		for(int i1=0;i1<currentlistSize;i1++) {
			T o1i=currentList.get(i1);
			for(int i2=0;i2<listTomatchSize;i2++) {
				T o2i=listToMatch.get(i2);
				if(o1i.equals(o2i)) {
					
					ArrayList<T> restListToMatch=new ArrayList<T>();

					for(int j2=0;j2<listTomatchSize;j2++) {
						if(j2!=i2) {
							restListToMatch.add(listToMatch.get(j2));
						}
					}
					if(currentlistSize==1) {
						
						for(T o:restListToMatch) {
							possibleNextset.add(o);
						}
						return possibleNextset;
					}else {
						// create arrays with remaining elements ...
						ArrayList<T> restCurrList=new ArrayList<T>();

						for(int j1=0;j1<currentlistSize;j1++) {
							if(j1!=i1) {
								restCurrList.add(currentList.get(j1));
							}
						}

						// ...to proceed recursively
						return residualNextElements(restListToMatch,restCurrList);
					}
				}
			}
		}
		// no match
		return possibleNextset;

	}
	

}
