/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.FloatStream;
import ipsk.io.InterleavedFloatStream;
import java.io.IOException;

public class InterleavedFloatStreamAdapter
implements InterleavedFloatStream {
    private FloatStream srcStream;
    private double[] monoBuf;

    public InterleavedFloatStreamAdapter(FloatStream srcStream) {
        this.srcStream = srcStream;
        this.monoBuf = new double[0];
    }

    @Override
    public int read(double[][] buf, int offset, int len) throws IOException {
        int r;
        if (this.monoBuf.length < len) {
            this.monoBuf = new double[len];
        }
        if ((r = this.srcStream.read(this.monoBuf, 0, len)) > 0) {
            for (int i = 0; i < r; ++i) {
                buf[offset + i][0] = this.monoBuf[i];
            }
        }
        return r;
    }

    @Override
    public long skip(long skip) throws IOException {
        return this.srcStream.skip(skip);
    }

    @Override
    public void close() throws IOException {
        this.srcStream.close();
    }

    @Override
    public Integer getChannels() {
        return 1;
    }
}

