/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.zip;

import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import ipsk.util.zip.ZipPackerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipPackerWorker
extends ProgressWorker {
    public static final boolean DEFAULT_LIMIT_TO_32BIT_SIZES = false;
    public static long MAX_32BIT_ZIP_FILE_SIZE = 0xFFFFFFFFL;
    public static int MAX_32BIT_ZIP_FILE_ENTRIES = 65536;
    public static int DEFAULT_BUF_SIZE = 32768;
    private ZipOutputStream zipStream;
    private int bufferSize = DEFAULT_BUF_SIZE;
    private byte[] buf;
    private long sizeDone = 0L;
    private File srcDir;
    private boolean packRecusive;
    private OutputStream outputStream;
    private boolean limitTo32bitSizes;

    @Override
    public void open() throws WorkerException {
        this.progressStatus.setLength(ProgressStatus.LENGTH_UNKNOWN);
        this.zipStream = new ZipOutputStream(this.outputStream);
        this.buf = new byte[this.bufferSize];
        super.open();
    }

    public boolean isLimitTo32bitSizes() {
        return this.limitTo32bitSizes;
    }

    public void setLimitTo32bitSizes(boolean limitTo32bitSizes) {
        this.limitTo32bitSizes = limitTo32bitSizes;
    }

    @Override
    public void doWork() throws WorkerException {
        this.progressStatus.setMessage(new LocalizableMessage("Calculating ZIP archive size..."));
        long length = 0L;
        try {
            length = this.limitTo32bitSizes ? this.calcRawSize(this.srcDir, MAX_32BIT_ZIP_FILE_SIZE, MAX_32BIT_ZIP_FILE_ENTRIES, 0L) : this.calcRawSize(this.srcDir);
        }
        catch (ZipPackerException e1) {
            e1.printStackTrace();
        }
        this.progressStatus.setLength(length);
        this.fireProgressEvent();
        try {
            this.packDirRecursive(this.srcDir);
            this.zipStream.close();
        }
        catch (IOException e) {
            throw new WorkerException(e);
        }
    }

    private void packDirRecursive(File dir) throws IOException {
        this.packDirRecursive("", dir);
    }

    private long calcRawSize(File dir, long maxSingleFileSize, long maxEntries, long entries) throws ZipPackerException {
        long size = 0L;
        for (File f : dir.listFiles()) {
            if (++entries > maxEntries) {
                throw new ZipPackerException("Too many ZIP archive entries.");
            }
            if (f.isDirectory()) {
                size += this.calcRawSize(f, maxSingleFileSize, maxEntries, entries);
                continue;
            }
            long fileLength = f.length();
            if (fileLength > maxSingleFileSize) {
                throw new ZipPackerException("File entry " + f + " too large.");
            }
            size += fileLength;
        }
        return size;
    }

    private long calcRawSize(File dir) throws ZipPackerException {
        long size = 0L;
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                size += this.calcRawSize(f);
                continue;
            }
            long fileLength = f.length();
            size += fileLength;
        }
        return size;
    }

    private void packDirRecursive(String base, File dir) throws IOException {
        if (this.hasCancelRequest()) {
            this.progressStatus.setMessage(new LocalizableMessage("Canceled !"));
            return;
        }
        Object dirName = base + dir.getName();
        if (!((String)dirName).endsWith(File.separator)) {
            dirName = ((String)dirName).concat("/");
        } else {
            ((String)dirName).replaceFirst(File.separator + "$", "/");
        }
        ZipEntry entry = new ZipEntry((String)dirName);
        this.zipStream.putNextEntry(entry);
        this.zipStream.closeEntry();
        for (File f : dir.listFiles()) {
            int read;
            if (this.hasCancelRequest()) {
                this.progressStatus.setMessage(new LocalizableMessage("Canceled !"));
                return;
            }
            if (f.isDirectory()) {
                this.packDirRecursive((String)dirName, f);
                continue;
            }
            this.progressStatus.setMessage(new LocalizableMessage("Pack " + f.getName() + " ..."));
            this.fireProgressEvent();
            FileInputStream fis = new FileInputStream(f);
            ZipEntry fe = new ZipEntry((String)dirName + f.getName());
            this.zipStream.putNextEntry(fe);
            while ((read = fis.read(this.buf)) != -1) {
                this.zipStream.write(this.buf, 0, read);
                this.sizeDone += (long)read;
                this.progressStatus.setProgress(this.sizeDone);
                this.fireProgressEvent();
            }
            this.zipStream.closeEntry();
            fis.close();
        }
    }

    public long getSizeDone() {
        return this.sizeDone;
    }

    public void setSizeDone(long sizeDone) {
        this.sizeDone = sizeDone;
    }

    public boolean isPackRecusive() {
        return this.packRecusive;
    }

    public void setPackRecusive(boolean packRecusive) {
        this.packRecusive = packRecusive;
    }

    public File getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

